/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.admin.deployment;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.xd.dirt.core.ModuleDeploymentsPath;
import org.springframework.xd.dirt.zookeeper.Paths;
import org.springframework.xd.module.ModuleDescriptor;

public class ModuleDeploymentStatus {
    private static final String STATUS_KEY = "status";
    private static final String ERROR_DESCRIPTION_KEY = "errorDescription";
    private final String container;
    private final int moduleSequence;
    private final ModuleDescriptor.Key key;
    private final State state;
    private final String errorDescription;

    public ModuleDeploymentStatus(String container, int moduleSequence, ModuleDescriptor.Key key, State state, String errorDescription) {
        this.container = container;
        this.moduleSequence = moduleSequence;
        this.key = key;
        this.state = state;
        this.errorDescription = errorDescription;
    }

    public ModuleDeploymentStatus(String container, int moduleSequence, ModuleDescriptor.Key key, Map<String, String> map) {
        this.container = container;
        this.moduleSequence = moduleSequence;
        this.key = key;
        Assert.state((boolean)map.containsKey(STATUS_KEY), (String)String.format("missing key '%s' from map; contents: %s", STATUS_KEY, map));
        this.state = State.valueOf(map.get(STATUS_KEY));
        this.errorDescription = map.get(ERROR_DESCRIPTION_KEY);
    }

    public String getContainer() {
        return this.container;
    }

    public int getModuleSequence() {
        return this.moduleSequence;
    }

    public String getModuleSequenceAsString() {
        return String.valueOf(this.moduleSequence);
    }

    public ModuleDescriptor.Key getKey() {
        return this.key;
    }

    public State getState() {
        return this.state;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(STATUS_KEY, this.state.toString());
        if (StringUtils.hasText((String)this.errorDescription)) {
            map.put(ERROR_DESCRIPTION_KEY, this.errorDescription);
        }
        return Collections.unmodifiableMap(map);
    }

    public String buildPath() {
        return Paths.build(new ModuleDeploymentsPath().setContainer(this.container).setDeploymentUnitName(this.key.getGroup()).setModuleType(this.key.getType().toString()).setModuleLabel(this.key.getLabel()).setModuleSequence(String.valueOf(this.moduleSequence)).build(), STATUS_KEY);
    }

    public String toString() {
        return "ModuleDeploymentStatus{container='" + this.container + '\'' + ", moduleSequence=" + this.moduleSequence + ", key=" + this.key + ", state=" + (Object)((Object)this.state) + ", errorDescription='" + this.errorDescription + '\'' + '}';
    }

    public static enum State {
        deployed,
        failed;

    }
}

