/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.admin.deployment;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Map;
import java.util.UUID;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentAction;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentUnitType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY)
public class DeploymentMessage {
    private String requestId;
    private DeploymentUnitType deploymentUnitType;
    private String unitName;
    private String definition;
    private DeploymentAction deploymentAction;
    private Map<String, String> deploymentProperties;

    public DeploymentMessage() {
    }

    public DeploymentMessage(DeploymentUnitType deploymentUnitType) {
        this.requestId = UUID.randomUUID().toString();
        this.deploymentUnitType = deploymentUnitType;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public String getDefinition() {
        return this.definition;
    }

    public DeploymentAction getDeploymentAction() {
        return this.deploymentAction;
    }

    public Map<String, String> getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public DeploymentUnitType getDeploymentUnitType() {
        return this.deploymentUnitType;
    }

    public DeploymentMessage setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public DeploymentMessage setUnitName(String unitName) {
        this.unitName = unitName;
        return this;
    }

    public DeploymentMessage setDefinition(String definition) {
        this.definition = definition;
        return this;
    }

    public DeploymentMessage setDeploymentAction(DeploymentAction deploymentAction) {
        this.deploymentAction = deploymentAction;
        return this;
    }

    public DeploymentMessage setDeploymentProperties(Map<String, String> deploymentProperties) {
        this.deploymentProperties = deploymentProperties;
        return this;
    }

    public String toString() {
        return "DeploymentMessage{requestId='" + this.requestId + '\'' + ", deploymentUnitType=" + (Object)((Object)this.deploymentUnitType) + ", unitName='" + this.unitName + '\'' + ", definition='" + this.definition + '\'' + ", deploymentAction=" + (Object)((Object)this.deploymentAction) + ", deploymentProperties=" + this.deploymentProperties + '}';
    }
}

