/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.admin.deployment;

import java.util.Collection;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.xd.dirt.core.DeploymentUnit;
import org.springframework.xd.dirt.core.DeploymentUnitStatus;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentUnitStateCalculator;
import org.springframework.xd.dirt.server.admin.deployment.ModuleDeploymentPropertiesProvider;
import org.springframework.xd.dirt.server.admin.deployment.ModuleDeploymentStatus;
import org.springframework.xd.module.ModuleDeploymentProperties;
import org.springframework.xd.module.ModuleDescriptor;

public class DefaultDeploymentUnitStateCalculator
implements DeploymentUnitStateCalculator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDeploymentUnitStateCalculator.class);

    @Override
    public DeploymentUnitStatus calculate(DeploymentUnit deploymentUnit, ModuleDeploymentPropertiesProvider<ModuleDeploymentProperties> provider, Collection<ModuleDeploymentStatus> deploymentStatuses) {
        HashMap<ModuleDescriptor.Key, Count> moduleCount = new HashMap<ModuleDescriptor.Key, Count>();
        for (ModuleDescriptor descriptor : deploymentUnit.getModuleDescriptors()) {
            moduleCount.put(descriptor.createKey(), new Count(provider.propertiesForDescriptor(descriptor).getCount()));
        }
        StringBuilder builder = new StringBuilder();
        logger.debug("Evaluating state for {}", (Object)deploymentUnit.getName());
        logger.trace("moduleCountMap: {}", moduleCount);
        for (ModuleDeploymentStatus deploymentStatus : deploymentStatuses) {
            logger.trace("\t{}", (Object)deploymentStatus);
            if (deploymentStatus.getState() == ModuleDeploymentStatus.State.deployed) {
                ModuleDescriptor.Key key = deploymentStatus.getKey();
                Count count = (Count)moduleCount.get(key);
                if (count == null || count.expected != 0 && ++count.actual != count.expected) continue;
                moduleCount.remove(key);
                continue;
            }
            if (!StringUtils.hasText((String)deploymentStatus.getErrorDescription())) continue;
            if (builder.length() > 0) {
                builder.append("; ");
            }
            builder.append(deploymentStatus.getErrorDescription());
        }
        logger.trace("moduleCountMap after evaluation: {}", moduleCount);
        if (moduleCount.isEmpty()) {
            return new DeploymentUnitStatus(DeploymentUnitStatus.State.deployed, builder.toString());
        }
        boolean failed = false;
        for (Count count : moduleCount.values()) {
            if (count.actual != 0) continue;
            failed = true;
            break;
        }
        DeploymentUnitStatus.State state = failed ? DeploymentUnitStatus.State.failed : DeploymentUnitStatus.State.incomplete;
        return new DeploymentUnitStatus(state, builder.toString());
    }

    private static class Count {
        final int expected;
        int actual;

        private Count(int expected) {
            this.expected = expected;
        }

        public String toString() {
            return "Count{expected=" + this.expected + ", actual=" + this.actual + '}';
        }
    }
}

