/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.admin.deployment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.xd.dirt.cluster.Container;
import org.springframework.xd.dirt.cluster.ContainerFilter;
import org.springframework.xd.module.ModuleDeploymentProperties;
import org.springframework.xd.module.ModuleDescriptor;

public class ContainerMatcher {
    private static final Logger logger = LoggerFactory.getLogger(ContainerMatcher.class);
    private int index;
    private final SpelExpressionParser expressionParser = new SpelExpressionParser();
    private final StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
    private final Collection<ContainerFilter> containerFilters;

    public ContainerMatcher() {
        this(new ContainerFilter[0]);
    }

    public ContainerMatcher(ContainerFilter ... containerFilters) {
        this.containerFilters = containerFilters != null ? Collections.unmodifiableList(Arrays.asList(containerFilters)) : Collections.emptyList();
        this.evaluationContext.addPropertyAccessor((PropertyAccessor)new MapAccessor());
    }

    public Collection<Container> match(ModuleDescriptor moduleDescriptor, ModuleDeploymentProperties deploymentProperties, Iterable<Container> containers) {
        Assert.notNull((Object)moduleDescriptor, (String)"'moduleDescriptor' cannot be null.");
        Assert.notNull((Object)deploymentProperties, (String)"'deploymentProperties' cannot be null.");
        Assert.notNull(containers, (String)"'containers' cannot be null.");
        logger.debug("Matching containers for module {}", (Object)moduleDescriptor);
        String criteria = deploymentProperties.getCriteria();
        List<Container> candidates = this.findAllContainersMatchingCriteria(containers, criteria);
        Collection<Container> filteredContainers = this.applyFilters(moduleDescriptor, candidates);
        ArrayList<Container> results = new ArrayList<Container>(filteredContainers);
        if (results.isEmpty() && StringUtils.hasText((String)criteria)) {
            logger.warn("No currently available containers match deployment criteria '{}' for module '{}'.", (Object)criteria, (Object)moduleDescriptor.getModuleName());
        }
        return this.distributeForRequestedCount(results, deploymentProperties.getCount());
    }

    private Collection<Container> applyFilters(ModuleDescriptor moduleDescriptor, Collection<Container> candidates) {
        for (ContainerFilter containerFilter : this.containerFilters) {
            candidates = containerFilter.filterContainers(moduleDescriptor, candidates);
        }
        return candidates;
    }

    private Collection<Container> distributeForRequestedCount(List<Container> candidates, int count) {
        int candidateCount = candidates.size();
        if (candidateCount == 0) {
            return candidates;
        }
        if (count <= 0 || count >= candidateCount) {
            return candidates;
        }
        if (count == 1) {
            return Collections.singleton(candidates.get(this.getAndRotateIndex(candidateCount)));
        }
        ArrayList<Container> targets = new ArrayList<Container>();
        while (targets.size() < count) {
            targets.add(candidates.get(this.getAndRotateIndex(candidateCount)));
        }
        return targets;
    }

    private List<Container> findAllContainersMatchingCriteria(Iterable<Container> containers, String criteria) {
        if (StringUtils.hasText((String)criteria)) {
            logger.debug("Matching containers for criteria '{}'", (Object)criteria);
        }
        ArrayList<Container> candidates = new ArrayList<Container>();
        for (Container container : containers) {
            logger.trace("Evaluating container {}", (Object)container);
            if (!StringUtils.isEmpty((Object)criteria) && !this.isCandidate(container, criteria)) continue;
            logger.trace("\tAdded container {}", (Object)container);
            candidates.add(container);
        }
        return candidates;
    }

    private boolean isCandidate(Container container, String criteria) {
        try {
            return (Boolean)this.expressionParser.parseExpression(criteria).getValue((EvaluationContext)this.evaluationContext, (Object)container.getAttributes(), Boolean.class);
        }
        catch (SpelEvaluationException e) {
            if (e.getMessageCode().equals((Object)SpelMessage.PROPERTY_OR_FIELD_NOT_READABLE)) {
                logger.debug("candidate does not contain an attribute referenced in the criteria {}", (Object)criteria);
            }
            return false;
        }
        catch (EvaluationException e) {
            logger.debug("candidate not a match due to evaluation exception", (Throwable)e);
            return false;
        }
    }

    private synchronized int getAndRotateIndex(int availableContainerCount) {
        if (availableContainerCount <= 0) {
            return 0;
        }
        int i = this.index % availableContainerCount;
        this.index = i + 1;
        return i;
    }
}

