/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server;

import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.integration.config.EnableIntegration;
import org.springframework.util.StringUtils;
import org.springframework.xd.dirt.server.MessageBusExtensionsConfiguration;
import org.springframework.xd.dirt.zookeeper.EmbeddedZooKeeper;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;

@Configuration
@EnableIntegration
@Import(value={PropertyPlaceholderAutoConfiguration.class, MessageBusExtensionsConfiguration.class})
@ImportResource(value={"META-INF/spring-xd/bus/${XD_TRANSPORT}-bus.xml", "META-INF/spring-xd/internal/repositories.xml", "META-INF/spring-xd/analytics/${XD_ANALYTICS}-analytics.xml"})
public class SharedServerContextConfiguration {
    public static final String ZK_CONNECT = "zk.client.connect";
    public static final String EMBEDDED_ZK_CONNECT = "zk.embedded.client.connect";
    public static final String ZK_PROPERTIES_SOURCE = "zk-properties";

    protected static class ZookeeperConnectionConfig
    implements EnvironmentAware {
        @Value(value="${zk.client.connect:}")
        protected String zkClientConnect;
        @Value(value="${zk.namespace:}")
        protected String zkNamespace;
        @Value(value="${zk.client.sessionTimeout:60000}")
        protected int zkSessionTimeout;
        @Value(value="${zk.client.connectionTimeout:30000}")
        protected int zkConnectionTimeout;
        @Value(value="${zk.client.initialRetryWait:1000}")
        protected int zkInitialRetryWait;
        @Value(value="${zk.client.retryMaxAttempts:3}")
        protected int zkRetryMaxAttempts;
        @Value(value="${zk.client.connection.configured:false}")
        private boolean zkConnectionConfigured;
        private ConfigurableEnvironment environment;
        private Properties zkProperties = new Properties();

        protected ZookeeperConnectionConfig() {
        }

        protected ZooKeeperConnection setupZookeeperPropertySource(String zkClientConnect, boolean isEmbedded) {
            if (!StringUtils.hasText((String)zkClientConnect)) {
                zkClientConnect = "localhost:2181";
            }
            if (!StringUtils.hasText((String)this.zkNamespace)) {
                this.zkNamespace = "xd";
            }
            if (isEmbedded) {
                this.zkProperties.put(SharedServerContextConfiguration.EMBEDDED_ZK_CONNECT, zkClientConnect);
            } else {
                this.zkProperties.put(SharedServerContextConfiguration.ZK_CONNECT, zkClientConnect);
            }
            this.environment.getPropertySources().addFirst((PropertySource)new PropertiesPropertySource(SharedServerContextConfiguration.ZK_PROPERTIES_SOURCE, this.zkProperties));
            ZooKeeperConnection zooKeeperConnection = new ZooKeeperConnection(zkClientConnect, this.zkNamespace, this.zkSessionTimeout, this.zkConnectionTimeout, this.zkInitialRetryWait, this.zkRetryMaxAttempts);
            zooKeeperConnection.setAutoStartup(!this.zkConnectionConfigured);
            return zooKeeperConnection;
        }

        public void setEnvironment(Environment environment) {
            this.environment = (ConfigurableEnvironment)environment;
        }
    }

    @Configuration
    @Profile(value={"!singlenode"})
    static class DistributedZooKeeperConfig
    extends ZookeeperConnectionConfig {
        DistributedZooKeeperConfig() {
        }

        @Bean
        public ZooKeeperConnection zooKeeperConnection() {
            return this.setupZookeeperPropertySource(this.zkClientConnect, false);
        }
    }

    @Configuration
    @Profile(value={"singlenode"})
    static class SingleNodeZooKeeperConfig
    extends ZookeeperConnectionConfig {
        @Value(value="${zk.client.connect:}")
        private String zkClientConnect;
        @Value(value="${zk.embedded.server.port:}")
        private Integer zkEmbeddedServerPort;
        @Autowired(required=false)
        EmbeddedZooKeeper embeddedZooKeeper;

        SingleNodeZooKeeperConfig() {
        }

        @Bean
        @ConditionalOnExpression(value="'${zk.client.connect}'.isEmpty()")
        EmbeddedZooKeeper embeddedZooKeeper() {
            if (this.zkEmbeddedServerPort != null) {
                return new EmbeddedZooKeeper(this.zkEmbeddedServerPort);
            }
            return new EmbeddedZooKeeper();
        }

        @Bean
        public ZooKeeperConnection zooKeeperConnection() {
            boolean isEmbedded;
            boolean bl = isEmbedded = this.embeddedZooKeeper != null;
            if (isEmbedded) {
                this.zkClientConnect = "localhost:" + this.embeddedZooKeeper.getClientPort();
            }
            return this.setupZookeeperPropertySource(this.zkClientConnect, isEmbedded);
        }
    }
}

