/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server;

import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.boot.actuate.autoconfigure.AuditAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.HealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.health.ApplicationHealthIndicator;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.batch.BatchAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.solr.SolrAutoConfiguration;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafAutoConfiguration;
import org.springframework.boot.autoconfigure.web.ServerPropertiesAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportResource;
import org.springframework.jmx.support.MBeanServerFactoryBean;

@EnableAutoConfiguration(exclude={ServerPropertiesAutoConfiguration.class, BatchAutoConfiguration.class, ThymeleafAutoConfiguration.class, JmxAutoConfiguration.class, HealthIndicatorAutoConfiguration.class, AuditAutoConfiguration.class, MongoAutoConfiguration.class, MongoDataAutoConfiguration.class, SolrAutoConfiguration.class})
@ImportResource(value={"classpath:META-INF/spring-xd/global/parent-context.xml"})
@EnableBatchProcessing
public class ParentConfiguration {
    @Bean
    @ConditionalOnExpression(value="${XD_JMX_ENABLED:false}")
    public MBeanServerFactoryBean mbeanServer() {
        MBeanServerFactoryBean factoryBean = new MBeanServerFactoryBean();
        factoryBean.setLocateExistingServerIfPossible(true);
        return factoryBean;
    }

    @Bean
    @ConditionalOnExpression(value="${endpoints.health.enabled:true}")
    public ApplicationHealthIndicator healthIndicator() {
        return new ApplicationHealthIndicator();
    }
}

