/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server;

import java.util.ArrayList;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ImportResource;
import org.springframework.integration.codec.Codec;
import org.springframework.integration.codec.kryo.FileKryoRegistrar;
import org.springframework.integration.codec.kryo.KryoRegistrar;
import org.springframework.integration.codec.kryo.PojoCodec;
import org.springframework.xd.tuple.serializer.kryo.TupleKryoRegistrar;

@ComponentScan(basePackages={"spring.xd.bus.ext"})
@ImportResource(value={"classpath*:META-INF/spring-xd/bus/ext/*.xml"})
public class MessageBusExtensionsConfiguration {
    @Autowired
    ApplicationContext applicationContext;
    @Value(value="${xd.codec.kryo.references}")
    private boolean useReferences;

    @Bean
    @ConditionalOnMissingBean(name={"codec"})
    public Codec codec() {
        Map kryoRegistrarMap = this.applicationContext.getBeansOfType(KryoRegistrar.class);
        return new PojoCodec(new ArrayList(kryoRegistrarMap.values()), this.useReferences);
    }

    @Bean
    public KryoRegistrar fileRegistrar() {
        return new FileKryoRegistrar();
    }

    @Bean
    public KryoRegistrar tupleRegistrar() {
        return new TupleKryoRegistrar();
    }
}

