/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;

public class MessageBusClassLoaderFactory
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    public static final String MESSAGE_BUS_JARS_LOCATION = "file:${XD_HOME}/lib/messagebus/${XD_TRANSPORT}/*.jar";
    private PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();

    private static URL[] getUrls(String ... patterns) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        ArrayList<URL> jars = new ArrayList<URL>();
        for (String pattern : patterns) {
            try {
                Resource[] resources;
                for (Resource resource : resources = resolver.getResources(pattern)) {
                    URL url = resource.getURL();
                    if (jars.contains(url)) continue;
                    jars.add(url);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return jars.toArray(new URL[jars.size()]);
    }

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        String transport = event.getEnvironment().resolvePlaceholders("${XD_TRANSPORT}");
        if (!"local".equals(transport)) {
            String jarsLocation = event.getEnvironment().resolvePlaceholders(MESSAGE_BUS_JARS_LOCATION);
            ((DefaultResourceLoader)this.resolver.getResourceLoader()).setClassLoader(this.makeClassLoader(jarsLocation));
        }
    }

    private ClassLoader makeClassLoader(String jarsLocation) {
        Object[] messageBusJars = MessageBusClassLoaderFactory.getUrls(jarsLocation);
        Assert.notEmpty((Object[])messageBusJars, (String)("Unable to locate any message bus implementation jars at location " + jarsLocation));
        return new URLClassLoader((URL[])messageBusJars, MessageBusClassLoaderFactory.class.getClassLoader());
    }

    public PathMatchingResourcePatternResolver getResolver() {
        return this.resolver;
    }
}

