/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server;

import java.util.Arrays;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.util.Assert;

public abstract class ApplicationUtils {
    public static ApplicationListener<?>[] mergeApplicationListeners(ApplicationListener<?> applicationListener, ApplicationListener<?>[] applicationListeners) {
        Assert.notEmpty((Object[])applicationListeners, (String)"applicationListeners[] must contain at least one item");
        int newLength = applicationListeners.length + 1;
        ApplicationListener<?>[] mergedApplicationListeners = Arrays.copyOf(applicationListeners, newLength);
        mergedApplicationListeners[newLength - 1] = applicationListener;
        return mergedApplicationListeners;
    }

    private static Map<String, Object> removeParentBeans(Map<String, Object> parentBeans, Map<String, Object> beans) {
        for (String key : parentBeans.keySet()) {
            beans.remove(key);
        }
        return beans;
    }

    public static String displayBeans(Map<String, Object> beans, String contextName) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append(contextName).append(":\n");
        for (Map.Entry<String, Object> entry : beans.entrySet()) {
            sb.append("\t[").append(entry.getKey()).append("] =").append(entry.getValue() != null ? entry.getValue().getClass().getName() : "null").append("\n");
        }
        return sb.toString();
    }

    public static void dumpContainerApplicationContextConfiguration(ApplicationContext containerContext) {
        Map globalBeans = containerContext.getParent().getParent().getParent().getBeansOfType(Object.class);
        Map sharedServerBeans = containerContext.getParent().getParent().getBeansOfType(Object.class);
        Map pluginBeans = containerContext.getParent().getBeansOfType(Object.class);
        Map containerBeans = containerContext.getBeansOfType(Object.class);
        ApplicationUtils.removeParentBeans(pluginBeans, containerBeans);
        ApplicationUtils.removeParentBeans(sharedServerBeans, pluginBeans);
        ApplicationUtils.removeParentBeans(globalBeans, sharedServerBeans);
        System.out.println(ApplicationUtils.displayBeans(globalBeans, "global context"));
        System.out.println(ApplicationUtils.displayBeans(sharedServerBeans, "shared server context"));
        System.out.println(ApplicationUtils.displayBeans(pluginBeans, "plugin context"));
        System.out.println(ApplicationUtils.displayBeans(containerBeans, "container context"));
    }
}

