/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest.validation;

import java.util.Date;
import java.util.TimeZone;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.scheduling.support.SimpleTriggerContext;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.xd.rest.domain.validation.CronValidation;

@Controller
@RequestMapping(value={"/validation"})
public class ValidationController {
    @RequestMapping(value={"/cron"}, method={RequestMethod.POST})
    @ResponseBody
    public CronValidation validateCronExpression(@RequestBody CronValidation cronValidation) {
        CronValidation cronValidationDtoToReturn = new CronValidation();
        cronValidationDtoToReturn.setCronExpression(cronValidation.getCronExpression());
        if (!StringUtils.hasText((String)cronValidation.getCronExpression())) {
            cronValidationDtoToReturn.setErrorMessage("The cron expression must not be empty.");
            return cronValidationDtoToReturn;
        }
        try {
            CronTrigger cronTrigger = new CronTrigger(cronValidation.getCronExpression(), TimeZone.getDefault());
            Date nextExecutionTime = cronTrigger.nextExecutionTime((TriggerContext)new SimpleTriggerContext());
            cronValidationDtoToReturn.setNextExecutionTime(nextExecutionTime);
        }
        catch (IllegalArgumentException e) {
            cronValidationDtoToReturn.setErrorMessage(e.getMessage());
            return cronValidationDtoToReturn;
        }
        cronValidationDtoToReturn.setValid(true);
        return cronValidationDtoToReturn;
    }
}

