/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest.security;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.xd.rest.domain.security.SecurityInfoResource;

@Controller
@RequestMapping(value={"/security/info"})
@ExposesResourceFor(value=SecurityInfoResource.class)
public class SecurityController {
    @Autowired
    private Environment environment;

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public SecurityInfoResource getSecurityInfo() {
        Authentication authentication;
        boolean authenticationEnabled = (Boolean)this.environment.getRequiredProperty("security.basic.enabled", Boolean.TYPE);
        SecurityInfoResource securityInfo = new SecurityInfoResource();
        securityInfo.setAuthenticationEnabled(authenticationEnabled);
        securityInfo.add(ControllerLinkBuilder.linkTo(SecurityController.class).withSelfRel());
        if (authenticationEnabled && SecurityContextHolder.getContext() != null && !((authentication = SecurityContextHolder.getContext().getAuthentication()) instanceof AnonymousAuthenticationToken)) {
            securityInfo.setAuthenticated(authentication.isAuthenticated());
            securityInfo.setUsername(authentication.getName());
        }
        return securityInfo;
    }
}

