/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest.metrics;

import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.hateoas.PagedResources;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.xd.analytics.metrics.core.RichGauge;
import org.springframework.xd.analytics.metrics.core.RichGaugeRepository;
import org.springframework.xd.dirt.analytics.NoSuchMetricException;
import org.springframework.xd.dirt.rest.metrics.AbstractMetricsController;
import org.springframework.xd.dirt.rest.metrics.DeepRichGaugeResourceAssembler;
import org.springframework.xd.rest.domain.metrics.MetricResource;
import org.springframework.xd.rest.domain.metrics.RichGaugeResource;

@Controller
@RequestMapping(value={"/metrics/rich-gauges"})
@ExposesResourceFor(value=RichGaugeResource.class)
public class RichGaugesController
extends AbstractMetricsController<RichGaugeRepository, RichGauge> {
    private final DeepRichGaugeResourceAssembler gaugeResourceAssembler = new DeepRichGaugeResourceAssembler();

    @Autowired
    public RichGaugesController(RichGaugeRepository repository) {
        super(repository);
    }

    @ResponseBody
    @RequestMapping(value={""}, method={RequestMethod.GET})
    public PagedResources<? extends MetricResource> list(Pageable pageable, PagedResourcesAssembler<RichGauge> pagedAssembler, @RequestParam(value="detailed", defaultValue="false") boolean detailed) {
        return this.list(pageable, pagedAssembler, detailed ? this.gaugeResourceAssembler : this.shallowResourceAssembler);
    }

    @ResponseBody
    @RequestMapping(value={"/{name}"}, method={RequestMethod.GET}, produces={"application/json"})
    public RichGaugeResource display(@PathVariable(value="name") String name) {
        RichGauge g = (RichGauge)((RichGaugeRepository)this.repository).findOne((Serializable)((Object)name));
        if (g == null) {
            throw new NoSuchMetricException(name, "There is no rich gauge named '%s'");
        }
        return this.gaugeResourceAssembler.toResource(g);
    }
}

