/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest.metrics;

import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.hateoas.PagedResources;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.xd.analytics.metrics.core.Gauge;
import org.springframework.xd.analytics.metrics.core.GaugeRepository;
import org.springframework.xd.dirt.analytics.NoSuchMetricException;
import org.springframework.xd.dirt.rest.metrics.AbstractMetricsController;
import org.springframework.xd.dirt.rest.metrics.DeepGaugeResourceAssembler;
import org.springframework.xd.rest.domain.metrics.GaugeResource;
import org.springframework.xd.rest.domain.metrics.MetricResource;

@Controller
@RequestMapping(value={"/metrics/gauges"})
@ExposesResourceFor(value=GaugeResource.class)
public class GaugesController
extends AbstractMetricsController<GaugeRepository, Gauge> {
    private final DeepGaugeResourceAssembler gaugeResourceAssembler = new DeepGaugeResourceAssembler();

    @Autowired
    public GaugesController(GaugeRepository repository) {
        super(repository);
    }

    @ResponseBody
    @RequestMapping(value={""}, method={RequestMethod.GET})
    public PagedResources<? extends MetricResource> list(Pageable pageable, PagedResourcesAssembler<Gauge> pagedAssembler, @RequestParam(value="detailed", defaultValue="false") boolean detailed) {
        return this.list(pageable, pagedAssembler, detailed ? this.gaugeResourceAssembler : this.shallowResourceAssembler);
    }

    @ResponseBody
    @RequestMapping(value={"/{name}"}, method={RequestMethod.GET})
    public GaugeResource display(@PathVariable(value="name") String name) {
        Gauge g = (Gauge)((GaugeRepository)this.repository).findOne((Serializable)((Object)name));
        if (g == null) {
            throw new NoSuchMetricException(name, "There is no gauge named '%s'");
        }
        return this.gaugeResourceAssembler.toResource(g);
    }
}

