/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest.metrics;

import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.hateoas.PagedResources;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.xd.analytics.metrics.core.FieldValueCounter;
import org.springframework.xd.analytics.metrics.core.FieldValueCounterRepository;
import org.springframework.xd.dirt.analytics.NoSuchMetricException;
import org.springframework.xd.dirt.rest.metrics.AbstractMetricsController;
import org.springframework.xd.dirt.rest.metrics.DeepFieldValueCounterResourceAssembler;
import org.springframework.xd.rest.domain.metrics.FieldValueCounterResource;
import org.springframework.xd.rest.domain.metrics.MetricResource;

@Controller
@RequestMapping(value={"/metrics/field-value-counters"})
@ExposesResourceFor(value=FieldValueCounterResource.class)
public class FieldValueCountersController
extends AbstractMetricsController<FieldValueCounterRepository, FieldValueCounter> {
    private final DeepFieldValueCounterResourceAssembler fvcResourceAssembler = new DeepFieldValueCounterResourceAssembler();

    @Autowired
    public FieldValueCountersController(FieldValueCounterRepository repository) {
        super(repository);
    }

    @ResponseBody
    @RequestMapping(value={""}, method={RequestMethod.GET})
    public PagedResources<? extends MetricResource> list(Pageable pageable, PagedResourcesAssembler<FieldValueCounter> pagedAssembler, @RequestParam(value="detailed", defaultValue="false") boolean detailed) {
        return this.list(pageable, pagedAssembler, detailed ? this.fvcResourceAssembler : this.shallowResourceAssembler);
    }

    @ResponseBody
    @RequestMapping(value={"/{name}"}, method={RequestMethod.GET}, produces={"application/json"})
    public FieldValueCounterResource display(@PathVariable(value="name") String name) {
        FieldValueCounter c = (FieldValueCounter)((FieldValueCounterRepository)this.repository).findOne((Serializable)((Object)name));
        if (c == null) {
            throw new NoSuchMetricException(name, "There is no field-value-counter named '%s'");
        }
        return this.fvcResourceAssembler.toResource(c);
    }
}

