/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest.metrics;

import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.xd.analytics.metrics.core.AggregateCount;
import org.springframework.xd.dirt.rest.metrics.AggregateCountersController;
import org.springframework.xd.rest.domain.metrics.AggregateCountsResource;

public class DeepAggregateCountResourceAssembler
extends ResourceAssemblerSupport<AggregateCount, AggregateCountsResource> {
    public DeepAggregateCountResourceAssembler() {
        super(AggregateCountersController.class, AggregateCountsResource.class);
    }

    public AggregateCountsResource toResource(AggregateCount entity) {
        return (AggregateCountsResource)this.createResourceWithId(entity.getName(), entity);
    }

    protected AggregateCountsResource instantiateResource(AggregateCount entity) {
        AggregateCountsResource result = new AggregateCountsResource(entity.getName());
        ReadablePeriod increment = entity.getResolution().unitPeriod;
        DateTime end = entity.getInterval().getEnd();
        int i = 0;
        DateTime when = entity.getInterval().getStart();
        while (!when.isAfter((ReadableInstant)end)) {
            result.addValue(new Date(when.getMillis()), entity.getCounts()[i++]);
            when = when.plus(increment);
        }
        return result;
    }
}

