/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest.metrics;

import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.hateoas.PagedResources;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.xd.analytics.metrics.core.Counter;
import org.springframework.xd.analytics.metrics.core.CounterRepository;
import org.springframework.xd.dirt.analytics.NoSuchMetricException;
import org.springframework.xd.dirt.rest.metrics.AbstractMetricsController;
import org.springframework.xd.dirt.rest.metrics.DeepCounterResourceAssembler;
import org.springframework.xd.rest.domain.metrics.CounterResource;
import org.springframework.xd.rest.domain.metrics.MetricResource;

@Controller
@RequestMapping(value={"/metrics/counters"})
@ExposesResourceFor(value=CounterResource.class)
public class CountersController
extends AbstractMetricsController<CounterRepository, Counter> {
    private final DeepCounterResourceAssembler counterResourceAssembler = new DeepCounterResourceAssembler();

    @Autowired
    public CountersController(CounterRepository counterRepository) {
        super(counterRepository);
    }

    @ResponseBody
    @RequestMapping(value={""}, method={RequestMethod.GET})
    public PagedResources<? extends MetricResource> list(Pageable pageable, PagedResourcesAssembler<Counter> pagedAssembler, @RequestParam(value="detailed", defaultValue="false") boolean detailed) {
        return this.list(pageable, pagedAssembler, detailed ? this.counterResourceAssembler : this.shallowResourceAssembler);
    }

    @ResponseBody
    @RequestMapping(value={"/{name}"}, method={RequestMethod.GET}, produces={"application/json"})
    public CounterResource display(@PathVariable(value="name") String name) {
        Counter c = (Counter)((CounterRepository)this.repository).findOne((Serializable)((Object)name));
        if (c == null) {
            throw new NoSuchMetricException(name, "There is no counter named '%s'");
        }
        return this.counterResourceAssembler.toResource(c);
    }
}

