/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest.metrics;

import java.util.LinkedList;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.xd.analytics.metrics.core.AggregateCount;
import org.springframework.xd.analytics.metrics.core.AggregateCountResolution;
import org.springframework.xd.analytics.metrics.core.AggregateCounterRepository;
import org.springframework.xd.analytics.metrics.core.Counter;
import org.springframework.xd.dirt.rest.metrics.AbstractMetricsController;
import org.springframework.xd.dirt.rest.metrics.DeepAggregateCountResourceAssembler;
import org.springframework.xd.rest.domain.metrics.AggregateCountsResource;
import org.springframework.xd.rest.domain.metrics.MetricResource;

@Controller
@RequestMapping(value={"/metrics/aggregate-counters"})
@ExposesResourceFor(value=AggregateCountsResource.class)
public class AggregateCountersController
extends AbstractMetricsController<AggregateCounterRepository, Counter> {
    private final DeepAggregateCountResourceAssembler aggregateCountResourceAssembler = new DeepAggregateCountResourceAssembler();

    @Autowired
    public AggregateCountersController(AggregateCounterRepository repository) {
        super(repository);
    }

    @ResponseBody
    @RequestMapping(value={""}, method={RequestMethod.GET})
    public PagedResources<? extends MetricResource> list(Pageable pageable, PagedResourcesAssembler<Counter> pagedAssembler, @RequestParam(value="detailed", defaultValue="false") boolean detailed, @RequestParam(value="from", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) DateTime from, @RequestParam(value="to", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) DateTime to, @RequestParam(value="resolution", defaultValue="hour") AggregateCountResolution resolution) {
        PagedResources<MetricResource> resources = this.list(pageable, pagedAssembler, this.shallowResourceAssembler);
        if (detailed) {
            to = this.providedOrDefaultToValue(to);
            from = this.providedOrDefaultFromValue(from, to, resolution);
            Interval interval = new Interval((ReadableInstant)from, (ReadableInstant)to);
            LinkedList<AggregateCountsResource> aggregateCounts = new LinkedList<AggregateCountsResource>();
            for (MetricResource metricResource : resources) {
                AggregateCount aggregateCount = ((AggregateCounterRepository)this.repository).getCounts(metricResource.getName(), interval, resolution);
                aggregateCounts.add(this.aggregateCountResourceAssembler.toResource(aggregateCount));
            }
            return new PagedResources(aggregateCounts, resources.getMetadata(), new Link[0]);
        }
        return resources;
    }

    @ResponseBody
    @RequestMapping(value={"/{name}"}, method={RequestMethod.GET}, produces={"application/json"})
    public AggregateCountsResource display(@PathVariable(value="name") String name, @RequestParam(value="from", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) DateTime from, @RequestParam(value="to", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) DateTime to, @RequestParam(value="resolution", defaultValue="hour") AggregateCountResolution resolution) {
        to = this.providedOrDefaultToValue(to);
        from = this.providedOrDefaultFromValue(from, to, resolution);
        AggregateCount aggregate = ((AggregateCounterRepository)this.repository).getCounts(name, new Interval((ReadableInstant)from, (ReadableInstant)to), resolution);
        return this.aggregateCountResourceAssembler.toResource(aggregate);
    }

    private DateTime providedOrDefaultToValue(DateTime to) {
        if (to == null) {
            to = new DateTime();
        }
        return to;
    }

    private DateTime providedOrDefaultFromValue(DateTime from, DateTime to, AggregateCountResolution resolution) {
        if (from != null) {
            return from;
        }
        switch (resolution) {
            case minute: {
                return to.minusMinutes(59);
            }
            case hour: {
                return to.minusHours(23);
            }
            case day: {
                return to.minusDays(6);
            }
            case month: {
                return to.minusMonths(11);
            }
            case year: {
                return to.minusYears(4);
            }
        }
        throw new IllegalStateException("Shouldn't happen. Unhandled resolution: " + resolution);
    }
}

