/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest.metrics;

import java.io.Serializable;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.xd.analytics.metrics.core.Metric;
import org.springframework.xd.analytics.metrics.core.MetricRepository;
import org.springframework.xd.dirt.analytics.NoSuchMetricException;
import org.springframework.xd.dirt.rest.metrics.ShallowMetricResourceAssembler;
import org.springframework.xd.rest.domain.metrics.MetricResource;

abstract class AbstractMetricsController<R extends MetricRepository<M>, M extends Metric> {
    protected final R repository;
    protected final ResourceAssembler<M, MetricResource> shallowResourceAssembler = new ShallowMetricResourceAssembler(this.getClass());

    public AbstractMetricsController(R repository) {
        this.repository = repository;
    }

    protected PagedResources<? extends MetricResource> list(Pageable pageable, PagedResourcesAssembler<M> pagedAssembler, ResourceAssembler<M, ? extends MetricResource> resourceAssembler) {
        Iterable metrics = this.repository.findAll();
        PageImpl page = new PageImpl((List)metrics);
        return pagedAssembler.toResource((Page)page, resourceAssembler == null ? this.shallowResourceAssembler : resourceAssembler);
    }

    @RequestMapping(value={"/{name}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    protected void delete(@PathVariable(value="name") String name) {
        if (!this.repository.exists((Serializable)((Object)name))) {
            throw new NoSuchMetricException(name, "Can't delete metric '%s' because it does not exist");
        }
        this.repository.delete((Serializable)((Object)name));
    }
}

