/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest.meta;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.xd.dirt.util.XdUtils;
import org.springframework.xd.rest.domain.meta.VersionResource;

@Controller
@RequestMapping(value={"/meta/version"})
@ExposesResourceFor(value=VersionResource.class)
public class VersionController {
    @Autowired
    private Environment environment;

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public VersionResource getVersion() {
        String version = XdUtils.getSpringXdVersion();
        VersionResource versionResource = StringUtils.hasText((String)version) ? new VersionResource(version) : new VersionResource();
        return versionResource;
    }
}

