/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.xd.dirt.core.BaseDefinition;
import org.springframework.xd.dirt.core.DeploymentUnitStatus;
import org.springframework.xd.dirt.integration.bus.rabbit.NothingToDeleteException;
import org.springframework.xd.dirt.integration.bus.rabbit.RabbitBusCleaner;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentAction;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentMessage;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentMessagePublisher;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentUnitType;
import org.springframework.xd.dirt.stream.AbstractInstancePersistingDeployer;
import org.springframework.xd.dirt.stream.BaseInstance;
import org.springframework.xd.dirt.stream.DeploymentValidator;
import org.springframework.xd.dirt.stream.NoSuchDefinitionException;
import org.springframework.xd.rest.domain.DeployableResource;
import org.springframework.xd.rest.domain.NamedResource;
import org.springframework.xd.rest.domain.support.DeploymentPropertiesFormat;

public abstract class XDController<D extends BaseDefinition, A extends ResourceAssemblerSupport<D, R>, R extends NamedResource, I extends BaseInstance<D>> {
    protected final AbstractInstancePersistingDeployer<D, I> deployer;
    private final DeploymentValidator validator;
    private A resourceAssemblerSupport;
    private final RabbitBusCleaner busCleaner = new RabbitBusCleaner();
    private final DeploymentUnitType deploymentUnitType;
    @Autowired
    private DeploymentMessagePublisher deploymentMessagePublisher;

    protected XDController(AbstractInstancePersistingDeployer<D, I> deployer, A resourceAssemblerSupport, DeploymentUnitType deploymentUnitType) {
        this.deployer = deployer;
        this.validator = deployer;
        this.resourceAssemblerSupport = resourceAssemblerSupport;
        this.deploymentUnitType = deploymentUnitType;
    }

    @RequestMapping(value={"/definitions/{name}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void delete(@PathVariable(value="name") String name) throws Exception {
        this.validator.validateBeforeDelete(name);
        this.deploymentMessagePublisher.poll(new DeploymentMessage(this.deploymentUnitType).setUnitName(name).setDeploymentAction(DeploymentAction.destroy));
    }

    @RequestMapping(value={"/definitions"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteAll() throws Exception {
        this.deploymentMessagePublisher.poll(new DeploymentMessage(this.deploymentUnitType).setDeploymentAction(DeploymentAction.destroyAll));
    }

    @RequestMapping(value={"/deployments/{name}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void undeploy(@PathVariable(value="name") String name) throws Exception {
        this.validator.validateBeforeUndeploy(name);
        this.deploymentMessagePublisher.poll(new DeploymentMessage(this.deploymentUnitType).setUnitName(name).setDeploymentAction(DeploymentAction.undeploy));
    }

    @RequestMapping(value={"/deployments"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void undeployAll() throws Exception {
        this.deploymentMessagePublisher.poll(new DeploymentMessage(this.deploymentUnitType).setDeploymentAction(DeploymentAction.undeployAll));
    }

    @RequestMapping(value={"/deployments/{name}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void deploy(@PathVariable(value="name") String name, @RequestParam(required=false) String properties) throws Exception {
        Map deploymentProperties = DeploymentPropertiesFormat.parseDeploymentProperties((String)properties);
        this.validator.validateBeforeDeploy(name, deploymentProperties);
        this.deploymentMessagePublisher.poll(new DeploymentMessage(this.deploymentUnitType).setUnitName(name).setDeploymentAction(DeploymentAction.deploy).setDeploymentProperties(deploymentProperties));
    }

    @RequestMapping(value={"/definitions/{name}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ResourceSupport display(@PathVariable(value="name") String name) throws Exception {
        Object definition = this.deployer.findOne(name);
        if (definition == null) {
            throw new NoSuchDefinitionException(name, "There is no definition named '%s'");
        }
        NamedResource resource = (NamedResource)this.resourceAssemblerSupport.toResource(definition);
        return this.enhanceWithDeployment(definition, resource);
    }

    protected PagedResources<R> listValues(Pageable pageable, PagedResourcesAssembler<D> assembler) {
        Page page = this.deployer.findAll(pageable);
        PagedResources result = assembler.toResource(page, this.resourceAssemblerSupport);
        if (page.getNumberOfElements() > 0) {
            this.enhanceWithDeployments(page, result);
        }
        return result;
    }

    private void enhanceWithDeployments(Page<D> page, PagedResources<R> result) {
        AbstractInstancePersistingDeployer<D, I> ipDeployer = this.deployer;
        BaseDefinition first = (BaseDefinition)page.getContent().get(0);
        BaseDefinition last = (BaseDefinition)page.getContent().get(page.getNumberOfElements() - 1);
        Iterator<I> deployedInstances = ipDeployer.deploymentInfo(first.getName(), last.getName()).iterator();
        BaseInstance instance = deployedInstances.hasNext() ? (BaseInstance)deployedInstances.next() : null;
        for (NamedResource definitionResource : result) {
            String instanceName;
            String string = instanceName = instance != null ? ((BaseDefinition)instance.getDefinition()).getName() : null;
            if (definitionResource.getName().equals(instanceName)) {
                ((DeployableResource)definitionResource).setStatus(instance.getStatus().getState().toString());
                instance = deployedInstances.hasNext() ? (BaseInstance)deployedInstances.next() : null;
                continue;
            }
            ((DeployableResource)definitionResource).setStatus(DeploymentUnitStatus.State.undeployed.toString());
        }
        if (deployedInstances.hasNext()) {
            ArrayList<String> uninspectedInstanceNames = new ArrayList<String>();
            while (deployedInstances.hasNext()) {
                BaseInstance uninspectedInstance = (BaseInstance)deployedInstances.next();
                uninspectedInstanceNames.add(((BaseDefinition)uninspectedInstance.getDefinition()).getName());
            }
            throw new IllegalStateException("Not all instances were looked at: " + StringUtils.collectionToCommaDelimitedString(uninspectedInstanceNames));
        }
    }

    @RequestMapping(value={"/definitions"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void save(@RequestParam(value="name") String name, @RequestParam(value="definition") String definition, @RequestParam(value="deploy", defaultValue="true") boolean deploy) throws Exception {
        DeploymentAction deploymentAction = deploy ? DeploymentAction.createAndDeploy : DeploymentAction.create;
        this.validator.validateBeforeSave(name, definition);
        this.deploymentMessagePublisher.poll(new DeploymentMessage(this.deploymentUnitType).setUnitName(name).setDeploymentAction(deploymentAction).setDefinition(definition));
    }

    private ResourceSupport enhanceWithDeployment(D definition, R resource) {
        AbstractInstancePersistingDeployer<D, I> ipDeployer = this.deployer;
        BaseInstance<D> deployedInstance = ipDeployer.deploymentInfo(((BaseDefinition)definition).getName());
        String status = deployedInstance != null ? deployedInstance.getStatus().getState().toString() : DeploymentUnitStatus.State.undeployed.toString();
        ((DeployableResource)resource).setStatus(status);
        return resource;
    }

    protected abstract D createDefinition(String var1, String var2);

    protected Map<String, List<String>> cleanRabbitBus(String stream, String adminUri, String user, String pw, String vhost, String busPrefix, boolean isJob) {
        Map<String, List<String>> results = this.busCleaner.clean(adminUri, user, pw, vhost, busPrefix, stream, isJob);
        if (results == null || results.size() == 0) {
            throw new NothingToDeleteException("Nothing to delete for stream " + stream);
        }
        return results;
    }

    public static class QueryOptions {
        public static final QueryOptions NONE = new QueryOptions();
        private boolean deployments;

        public boolean isDeployments() {
            return this.deployments;
        }

        public void setDeployments(boolean deployments) {
            this.deployments = deployments;
        }
    }
}

