/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.xd.dirt.job.dsl.Graph;
import org.springframework.xd.dirt.job.dsl.JobParser;
import org.springframework.xd.dirt.job.dsl.JobSpecificationException;
import org.springframework.xd.dirt.rest.DocumentParseResultResourceAssembler;
import org.springframework.xd.dirt.stream.DocumentParseResult;
import org.springframework.xd.dirt.stream.XDStreamParser;
import org.springframework.xd.rest.domain.DocumentParseResultResource;

@RestController
@RequestMapping(value={"/tools"})
public class ToolsController {
    private XDStreamParser.MultiLineDocumentParser multilineStreamParser;
    private DocumentParseResultResourceAssembler assembler = new DocumentParseResultResourceAssembler();

    @Autowired
    public ToolsController(XDStreamParser streamParser) {
        this.multilineStreamParser = new XDStreamParser.MultiLineDocumentParser(streamParser);
    }

    @RequestMapping(value={"/parse"}, method={RequestMethod.GET})
    public DocumentParseResultResource validate(@RequestParam(value="definitions") String definitions) {
        DocumentParseResult parse = this.multilineStreamParser.parse(definitions.split("\n"));
        return this.assembler.toResource(parse);
    }

    @RequestMapping(value={"/parseJobToGraph"}, method={RequestMethod.POST})
    public Map<String, Object> parseJobToGraph(@RequestBody String specification) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        JobParser jobParser = new JobParser();
        try {
            Graph graph = jobParser.getGraph(specification);
            response.put("graph", graph);
        }
        catch (JobSpecificationException jse) {
            response.put("error", jse.toExceptionDescriptor());
        }
        return response;
    }

    @RequestMapping(value={"/convertJobGraphToText"}, method={RequestMethod.POST})
    public Map<String, Object> convertJobGrabToText(@RequestBody Graph graph) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            String dslText = graph.toDSLText();
            response.put("text", dslText);
        }
        catch (JobSpecificationException jse) {
            response.put("error", jse.toExceptionDescriptor());
        }
        catch (Throwable e) {
            response.put("error", e.toString());
        }
        return response;
    }
}

