/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.hateoas.PagedResources;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.xd.dirt.rest.PasswordUtils;
import org.springframework.xd.dirt.rest.StreamDefinitionResourceAssembler;
import org.springframework.xd.dirt.rest.XDController;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentUnitType;
import org.springframework.xd.dirt.stream.Stream;
import org.springframework.xd.dirt.stream.StreamDefinition;
import org.springframework.xd.dirt.stream.StreamDeployer;
import org.springframework.xd.rest.domain.StreamDefinitionResource;

@Controller
@RequestMapping(value={"/streams"})
@ExposesResourceFor(value=StreamDefinitionResource.class)
public class StreamsController
extends XDController<StreamDefinition, StreamDefinitionResourceAssembler, StreamDefinitionResource, Stream> {
    @Autowired
    public StreamsController(StreamDeployer streamDeployer) {
        super(streamDeployer, new StreamDefinitionResourceAssembler(), DeploymentUnitType.Stream);
    }

    @ResponseBody
    @RequestMapping(value={"/definitions"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public PagedResources<StreamDefinitionResource> list(Pageable pageable, PagedResourcesAssembler<StreamDefinition> assembler) {
        PagedResources pagedResources = this.listValues(pageable, assembler);
        ArrayList<StreamDefinitionResource> maskedContents = new ArrayList<StreamDefinitionResource>(pagedResources.getContent().size());
        for (StreamDefinitionResource streamDefinitionResource : pagedResources.getContent()) {
            streamDefinitionResource.getDefinition();
            StreamDefinitionResource maskedStreamDefinitionResource = new StreamDefinitionResource(streamDefinitionResource.getName(), PasswordUtils.maskPasswordsInDefinition(streamDefinitionResource.getDefinition()));
            maskedStreamDefinitionResource.setStatus(streamDefinitionResource.getStatus());
            maskedContents.add(maskedStreamDefinitionResource);
        }
        return new PagedResources(maskedContents, pagedResources.getMetadata(), (Iterable)pagedResources.getLinks());
    }

    @Override
    protected StreamDefinition createDefinition(String name, String definition) {
        return new StreamDefinition(name, definition);
    }

    @ResponseBody
    @RequestMapping(value={"/clean/rabbit/{stream}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public Map<String, List<String>> clean(@PathVariable String stream, @RequestParam(required=false) String adminUri, @RequestParam(required=false) String user, @RequestParam(required=false) String pw, @RequestParam(required=false) String vhost, @RequestParam(required=false) String busPrefix) {
        return this.cleanRabbitBus(stream, adminUri, user, pw, vhost, busPrefix, false);
    }
}

