/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.VndErrors;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.UnsatisfiedServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.xd.dirt.analytics.NoSuchMetricException;
import org.springframework.xd.dirt.cluster.ContainerShutdownException;
import org.springframework.xd.dirt.cluster.ModuleMessageRateNotFoundException;
import org.springframework.xd.dirt.cluster.NoSuchContainerException;
import org.springframework.xd.dirt.integration.bus.RabbitAdminException;
import org.springframework.xd.dirt.integration.bus.rabbit.NothingToDeleteException;
import org.springframework.xd.dirt.job.BatchJobAlreadyExistsException;
import org.springframework.xd.dirt.job.JobExecutionAlreadyRunningException;
import org.springframework.xd.dirt.job.JobExecutionNotRunningException;
import org.springframework.xd.dirt.job.JobInstanceAlreadyCompleteException;
import org.springframework.xd.dirt.job.JobParametersInvalidException;
import org.springframework.xd.dirt.job.JobRestartException;
import org.springframework.xd.dirt.job.NoSuchBatchJobException;
import org.springframework.xd.dirt.job.NoSuchBatchJobInstanceException;
import org.springframework.xd.dirt.job.NoSuchJobExecutionException;
import org.springframework.xd.dirt.job.NoSuchStepExecutionException;
import org.springframework.xd.dirt.module.ModuleAlreadyExistsException;
import org.springframework.xd.dirt.module.ModuleNotDeployedException;
import org.springframework.xd.dirt.module.NoSuchModuleException;
import org.springframework.xd.dirt.stream.AlreadyDeployedException;
import org.springframework.xd.dirt.stream.DefinitionAlreadyExistsException;
import org.springframework.xd.dirt.stream.NoSuchDefinitionException;
import org.springframework.xd.dirt.stream.NotDeployedException;
import org.springframework.xd.dirt.stream.dsl.StreamDefinitionException;
import org.springframework.xd.dirt.util.PageNotFoundException;

@ControllerAdvice
public class RestControllerAdvice {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public VndErrors onMissingServletRequestParameterException(MissingServletRequestParameterException e) {
        String logref = this.logDebug((Throwable)e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public VndErrors onException(Exception e) {
        String logref = this.logError(e);
        String msg = StringUtils.hasText((String)e.getMessage()) ? e.getMessage() : e.getClass().getSimpleName();
        return new VndErrors(logref, msg, new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public VndErrors onNoSuchDefinitionException(NoSuchDefinitionException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public VndErrors onDefinitionAlreadyExistsException(DefinitionAlreadyExistsException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public VndErrors onAlreadyDeployedException(AlreadyDeployedException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public VndErrors onNotDeployedException(NotDeployedException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public VndErrors onInvalidDefinition(StreamDefinitionException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.CONFLICT)
    public VndErrors onModuleAlreadyExistsException(ModuleAlreadyExistsException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public VndErrors onNoSuchMetricException(NoSuchMetricException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public VndErrors onModuleNotDeployedException(ModuleNotDeployedException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public VndErrors onNoSuchModuleException(NoSuchModuleException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public VndErrors onNoSuchJobExecutionException(NoSuchJobExecutionException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public VndErrors onJobExecutionNotRunningException(JobExecutionNotRunningException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public VndErrors onNoSuchStepExecutionException(NoSuchStepExecutionException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    private String logDebug(Throwable t) {
        this.logger.debug("Caught exception while handling a request", t);
        return t.getClass().getSimpleName();
    }

    private String logError(Throwable t) {
        this.logger.error("Caught exception while handling a request", t);
        return t.getClass().getSimpleName();
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public VndErrors onJobExecutionAlreadyRunningException(JobExecutionAlreadyRunningException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public VndErrors onJobRestartException(JobRestartException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public VndErrors onJobInstanceAlreadyCompleteException(JobInstanceAlreadyCompleteException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public VndErrors onNoSuchJobException(NoSuchBatchJobException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public VndErrors onBatchJobAlreadyExists(BatchJobAlreadyExistsException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public VndErrors onNoSuchJobInstanceException(NoSuchBatchJobInstanceException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public VndErrors onContainerShutdownException(ContainerShutdownException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public VndErrors onJobParametersInvalidException(JobParametersInvalidException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public VndErrors onNoSuchContainerException(NoSuchContainerException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public VndErrors onModuleMessageRateNotFoundException(ModuleMessageRateNotFoundException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public VndErrors onNoSuchPageException(PageNotFoundException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public VndErrors onNothingToDeleteException(NothingToDeleteException e) {
        String logref = this.logDebug((Throwable)((Object)e));
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public VndErrors onRabbitAdminException(RabbitAdminException e) {
        String logref = this.logDebug((Throwable)e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public VndErrors onBadCredentialsException(BadCredentialsException e) {
        String logref = this.logDebug((Throwable)e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public VndErrors onUnsatisfiedServletRequestParameterException(UnsatisfiedServletRequestParameterException e) {
        String logref = this.logDebug((Throwable)e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }
}

