/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.text.DateFormat;
import java.util.List;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.web.config.EnableSpringDataWebSupport;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.mvc.WebContentInterceptor;
import org.springframework.xd.dirt.plugins.job.support.ExecutionContextJacksonMixIn;
import org.springframework.xd.dirt.plugins.job.support.StepExecutionJacksonMixIn;
import org.springframework.xd.dirt.rest.AccessControlInterceptor;
import org.springframework.xd.rest.domain.support.RestTemplateMessageConverterUtil;
import org.springframework.xd.rest.domain.util.ISO8601DateFormatWithMilliSeconds;

@Configuration
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
@EnableSpringDataWebSupport
@ComponentScan(excludeFilters={@ComponentScan.Filter(value={Configuration.class})})
public class RestConfiguration {
    @Bean
    public WebContentInterceptor webContentInterceptor() {
        WebContentInterceptor webContentInterceptor = new WebContentInterceptor();
        webContentInterceptor.setCacheSeconds(0);
        return webContentInterceptor;
    }

    @Bean
    public WebMvcConfigurer configurer() {
        return new WebMvcConfigurerAdapter(){
            @Value(value="${xd.ui.allow_origin:http://localhost:9889}")
            private String allowedOrigin;

            public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
                RestTemplateMessageConverterUtil.installMessageConverters(converters);
                for (HttpMessageConverter<?> httpMessageConverter : converters) {
                    if (!(httpMessageConverter instanceof MappingJackson2HttpMessageConverter)) continue;
                    MappingJackson2HttpMessageConverter converter = (MappingJackson2HttpMessageConverter)httpMessageConverter;
                    ObjectMapper objectMapper = converter.getObjectMapper();
                    objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
                    objectMapper.setDateFormat((DateFormat)new ISO8601DateFormatWithMilliSeconds());
                    objectMapper.addMixInAnnotations(StepExecution.class, StepExecutionJacksonMixIn.class);
                    objectMapper.addMixInAnnotations(ExecutionContext.class, ExecutionContextJacksonMixIn.class);
                }
                converters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
            }

            public void addInterceptors(InterceptorRegistry registry) {
                registry.addInterceptor((HandlerInterceptor)new AccessControlInterceptor(this.allowedOrigin));
                registry.addInterceptor((HandlerInterceptor)RestConfiguration.this.webContentInterceptor());
            }
        };
    }
}

