/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest;

import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PasswordUtils {
    public static final String[] PASSWORD_PARAMETER_NAMES = new String[]{"password", "passwd"};
    public static final String MASK_CHARACTER = "*";
    public static Pattern passwordParameterPattern = Pattern.compile("(?i)(--[\\p{Z}]*[\\p{L}]*(" + StringUtils.arrayToDelimitedString((Object[])PASSWORD_PARAMETER_NAMES, (String)"|") + ")[\\p{L}]*[\\p{Z}]*=[\\p{Z}]*)((\"[\\p{L}|\\p{Pd}|\\p{Ps}|\\p{Pe}|\\p{Pc}|\\p{S}|\\p{N}|\\p{Z}]*\")|([\\p{N}|\\p{L}|\\p{Po}|\\p{Pc}|\\p{S}]*))", 64);

    private PasswordUtils() {
        throw new AssertionError();
    }

    public static String maskPasswordsInDefinition(String definition) {
        Assert.hasText((String)definition, (String)"definition must be neither empty nor null.");
        StringBuffer output = new StringBuffer();
        Matcher matcher = passwordParameterPattern.matcher(definition);
        while (matcher.find()) {
            String maskedPasswordValue;
            String passwordValue = matcher.group(3);
            if (passwordValue.startsWith("\"") && passwordValue.endsWith("\"")) {
                String passwordValueWithoutQuotes = passwordValue.substring(1, passwordValue.length() - 1);
                maskedPasswordValue = "\"" + PasswordUtils.maskString(passwordValueWithoutQuotes) + "\"";
            } else {
                maskedPasswordValue = PasswordUtils.maskString(matcher.group(3));
            }
            matcher.appendReplacement(output, matcher.group(1) + maskedPasswordValue);
        }
        matcher.appendTail(output);
        return output.toString();
    }

    public static String maskString(String stringToMask) {
        Assert.notNull((Object)stringToMask, (String)"'stringToMask' must not be null.");
        return stringToMask.replaceAll(".", MASK_CHARACTER);
    }

    public static void maskPropertiesIfNecessary(Properties properties) {
        Assert.notNull((Object)properties, (String)"'properties' must not be null.");
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            if (!(property.getKey() instanceof String) || !(property.getValue() instanceof String)) continue;
            String propertyKey = (String)property.getKey();
            String propertyValue = (String)property.getValue();
            for (String param : PASSWORD_PARAMETER_NAMES) {
                if (!propertyKey.toLowerCase().contains(param.toLowerCase())) continue;
                properties.setProperty(propertyKey, PasswordUtils.maskString(propertyValue));
            }
        }
    }
}

