/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.xd.dirt.module.ModuleNotDeployedException;
import org.springframework.xd.dirt.module.store.ModuleMetadata;
import org.springframework.xd.dirt.module.store.ModuleMetadataRepository;
import org.springframework.xd.dirt.rest.ModuleMetadataResourceAssembler;
import org.springframework.xd.dirt.rest.PasswordUtils;
import org.springframework.xd.rest.domain.ModuleMetadataResource;

@Controller
@RequestMapping(value={"/runtime/modules"})
@ExposesResourceFor(value=ModuleMetadataResource.class)
public class ModulesMetadataController {
    private final ModuleMetadataRepository moduleMetadataRepository;
    private ResourceAssemblerSupport<ModuleMetadata, ModuleMetadataResource> moduleMetadataResourceAssembler;

    @Autowired
    public ModulesMetadataController(ModuleMetadataRepository moduleMetadataRepository) {
        this.moduleMetadataRepository = moduleMetadataRepository;
        this.moduleMetadataResourceAssembler = new ModuleMetadataResourceAssembler();
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public PagedResources<ModuleMetadataResource> list(Pageable pageable, PagedResourcesAssembler<ModuleMetadata> assembler) {
        Page page = this.moduleMetadataRepository.findAll(pageable);
        return this.maskSensitiveData((PagedResources<ModuleMetadataResource>)assembler.toResource(page, this.moduleMetadataResourceAssembler));
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, params={"containerId"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public PagedResources<ModuleMetadataResource> listByContainer(Pageable pageable, PagedResourcesAssembler<ModuleMetadata> assembler, @RequestParam(value="containerId") String containerId) {
        return this.maskSensitiveData((PagedResources<ModuleMetadataResource>)assembler.toResource(this.moduleMetadataRepository.findAllByContainerId(pageable, containerId), this.moduleMetadataResourceAssembler));
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, params={"moduleId"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public PagedResources<ModuleMetadataResource> listByModule(Pageable pageable, PagedResourcesAssembler<ModuleMetadata> assembler, @RequestParam(value="moduleId") String moduleId) {
        return this.maskSensitiveData((PagedResources<ModuleMetadataResource>)assembler.toResource(this.moduleMetadataRepository.findAllByModuleId(pageable, moduleId), this.moduleMetadataResourceAssembler));
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, params={"containerId", "moduleId"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ModuleMetadataResource listByContainerAndModuleId(@RequestParam(value="containerId") String containerId, @RequestParam(value="moduleId") String moduleId) {
        ModuleMetadata moduleMetadata = this.moduleMetadataRepository.findOne(containerId, moduleId);
        if (moduleMetadata == null) {
            throw new ModuleNotDeployedException(containerId, moduleId);
        }
        return this.maskSensitiveData((ModuleMetadataResource)this.moduleMetadataResourceAssembler.toResource((Object)moduleMetadata));
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, params={"jobname"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<ModuleMetadataResource> displayForJobname(@RequestParam(value="jobname") String jobName) {
        Iterable moduleMetadataIterable = this.moduleMetadataRepository.findAll();
        ArrayList<ModuleMetadata> moduleMetadataListToReturn = new ArrayList<ModuleMetadata>();
        for (ModuleMetadata moduleMetadata : moduleMetadataIterable) {
            if (!jobName.equals(moduleMetadata.getUnitName())) continue;
            moduleMetadataListToReturn.add(moduleMetadata);
        }
        List resources = this.moduleMetadataResourceAssembler.toResources(moduleMetadataListToReturn);
        this.maskSensitiveData(resources);
        return resources;
    }

    private ModuleMetadataResource maskSensitiveData(ModuleMetadataResource moduleMetadataResource) {
        PasswordUtils.maskPropertiesIfNecessary(moduleMetadataResource.getModuleOptions());
        return moduleMetadataResource;
    }

    private PagedResources<ModuleMetadataResource> maskSensitiveData(PagedResources<ModuleMetadataResource> moduleMetadataResources) {
        this.maskSensitiveData(moduleMetadataResources.getContent());
        return moduleMetadataResources;
    }

    private Collection<ModuleMetadataResource> maskSensitiveData(Collection<ModuleMetadataResource> moduleMetadataResources) {
        for (ModuleMetadataResource metadataResource : moduleMetadataResources) {
            this.maskSensitiveData(metadataResource);
        }
        return moduleMetadataResources;
    }
}

