/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.xd.dirt.module.NoSuchModuleException;
import org.springframework.xd.dirt.module.support.ModuleDefinitionService;
import org.springframework.xd.dirt.rest.DetailedModuleDefinitionResourceAssembler;
import org.springframework.xd.dirt.rest.ModuleDefinitionResourceAssembler;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.ModuleType;
import org.springframework.xd.rest.domain.DetailedModuleDefinitionResource;
import org.springframework.xd.rest.domain.ModuleDefinitionResource;

@Controller
@RequestMapping(value={"/modules"})
@ExposesResourceFor(value=ModuleDefinitionResource.class)
public class ModulesController {
    private final ModuleDefinitionService moduleDefinitionService;
    private final DetailedModuleDefinitionResourceAssembler detailedAssembler;
    private ModuleDefinitionResourceAssembler simpleAssembler = new ModuleDefinitionResourceAssembler();

    @Autowired
    public ModulesController(ModuleDefinitionService moduleDefinitionService, DetailedModuleDefinitionResourceAssembler detailedAssembler) {
        Assert.notNull((Object)moduleDefinitionService, (String)"moduleDefinitionService must not be null");
        Assert.notNull((Object)((Object)detailedAssembler), (String)"detailedAssembler must not be null");
        this.moduleDefinitionService = moduleDefinitionService;
        this.detailedAssembler = detailedAssembler;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public PagedResources<? extends ModuleDefinitionResource> list(Pageable pageable, PagedResourcesAssembler<ModuleDefinition> assembler, @RequestParam(value="type", required=false) ModuleType type, @RequestParam(value="detailed", defaultValue="false") boolean detailed) {
        Page<ModuleDefinition> page = type == null ? this.moduleDefinitionService.findDefinitions(pageable) : this.moduleDefinitionService.findDefinitions(pageable, type);
        DetailedModuleDefinitionResourceAssembler ra = this.detailedAssembler;
        return assembler.toResource(page, (ResourceAssembler)(detailed ? ra : this.simpleAssembler));
    }

    @RequestMapping(value={"/{type}/{name}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public DetailedModuleDefinitionResource info(@PathVariable(value="type") ModuleType type, @PathVariable(value="name") String name) {
        ModuleDefinition def = this.moduleDefinitionService.findDefinition(name, type);
        if (def == null) {
            throw new NoSuchModuleException(name, type);
        }
        return this.detailedAssembler.toResource(def);
    }

    @RequestMapping(value={""}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public ModuleDefinitionResource compose(@RequestParam(value="name") String name, @RequestParam(value="definition") String definition, @RequestParam(value="force", defaultValue="false") boolean force) {
        ModuleDefinition moduleDefinition = this.moduleDefinitionService.compose(name, null, definition, force);
        ModuleDefinitionResource resource = this.simpleAssembler.toResource(moduleDefinition);
        return resource;
    }

    @RequestMapping(value={"/{type}/{name}"}, method={RequestMethod.POST}, consumes={"text/plain"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public ModuleDefinitionResource compose(@PathVariable(value="type") ModuleType type, @PathVariable(value="name") String name, @RequestBody String definition, @RequestParam(value="force", defaultValue="false") boolean force) {
        ModuleDefinition moduleDefinition = this.moduleDefinitionService.compose(name, type, definition, force);
        ModuleDefinitionResource resource = this.simpleAssembler.toResource(moduleDefinition);
        return resource;
    }

    @RequestMapping(value={"/{type}/{name}"}, method={RequestMethod.POST}, consumes={"application/octet-stream"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public ModuleDefinitionResource upload(@PathVariable(value="type") ModuleType type, @PathVariable(value="name") String name, @RequestParam(value="force", defaultValue="false") boolean force, @RequestBody byte[] bytes) {
        ModuleDefinition moduleDefinition = this.moduleDefinitionService.upload(name, type, bytes, force);
        ModuleDefinitionResource resource = this.simpleAssembler.toResource(moduleDefinition);
        return resource;
    }

    @RequestMapping(value={"/{type}/{name}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void delete(@PathVariable(value="type") ModuleType type, @PathVariable(value="name") String name) {
        this.moduleDefinitionService.delete(name, type);
    }
}

