/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.hateoas.PagedResources;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.xd.dirt.job.BatchJobAlreadyExistsException;
import org.springframework.xd.dirt.job.dsl.ComposedJobUtil;
import org.springframework.xd.dirt.module.support.ModuleDefinitionService;
import org.springframework.xd.dirt.plugins.job.DistributedJobLocator;
import org.springframework.xd.dirt.rest.JobDefinitionResourceAssembler;
import org.springframework.xd.dirt.rest.PasswordUtils;
import org.springframework.xd.dirt.rest.XDController;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentUnitType;
import org.springframework.xd.dirt.stream.Job;
import org.springframework.xd.dirt.stream.JobDefinition;
import org.springframework.xd.dirt.stream.JobDeployer;
import org.springframework.xd.module.ModuleType;
import org.springframework.xd.rest.domain.JobDefinitionResource;

@Controller
@RequestMapping(value={"/jobs"})
@ExposesResourceFor(value=JobDefinitionResource.class)
public class JobsController
extends XDController<JobDefinition, JobDefinitionResourceAssembler, JobDefinitionResource, Job> {
    private ModuleDefinitionService moduleDefinitionService;
    @Autowired
    private DistributedJobLocator distributedJobLocator;

    @Autowired
    public JobsController(JobDeployer jobDeployer, ModuleDefinitionService moduleDefinitionService) {
        super(jobDeployer, new JobDefinitionResourceAssembler(), DeploymentUnitType.Job);
        this.moduleDefinitionService = moduleDefinitionService;
    }

    @Override
    @RequestMapping(value={"/definitions"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void save(@RequestParam(value="name") String name, @RequestParam(value="definition") String definition, @RequestParam(value="deploy", defaultValue="true") boolean deploy) throws Exception {
        if (this.distributedJobLocator.getJobNames().contains(name)) {
            throw new BatchJobAlreadyExistsException(name);
        }
        if (ComposedJobUtil.isComposedJobDefinition(definition)) {
            this.moduleDefinitionService.compose(ComposedJobUtil.getComposedJobModuleName(name), ModuleType.job, definition, false);
        } else {
            ComposedJobUtil.validateNotSingleJobInstance(definition, this.distributedJobLocator.getJobNames());
        }
        super.save(name, definition, deploy);
    }

    @Override
    @RequestMapping(value={"/definitions/{name}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void delete(@PathVariable(value="name") String name) throws Exception {
        super.delete(name);
        if (this.moduleDefinitionService.findDefinition(ComposedJobUtil.getComposedJobModuleName(name), ModuleType.job) != null) {
            this.moduleDefinitionService.delete(ComposedJobUtil.getComposedJobModuleName(name), ModuleType.job);
        }
    }

    @Override
    @RequestMapping(value={"/definitions"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteAll() throws Exception {
        Iterable jobDefinitions = this.deployer.findAll();
        super.deleteAll();
        for (JobDefinition jobDefinition : jobDefinitions) {
            if (this.moduleDefinitionService.findDefinition(ComposedJobUtil.getComposedJobModuleName(jobDefinition.getName()), ModuleType.job) == null) continue;
            this.moduleDefinitionService.delete(ComposedJobUtil.getComposedJobModuleName(jobDefinition.getName()), ModuleType.job);
        }
    }

    @RequestMapping(value={"/definitions"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public PagedResources<JobDefinitionResource> list(Pageable pageable, PagedResourcesAssembler<JobDefinition> assembler) {
        PagedResources pagedResources = this.listValues(pageable, assembler);
        ArrayList<JobDefinitionResource> maskedContents = new ArrayList<JobDefinitionResource>(pagedResources.getContent().size());
        for (JobDefinitionResource jobDefinitionResource : pagedResources.getContent()) {
            jobDefinitionResource.getDefinition();
            JobDefinitionResource maskedJobDefinitionResource = new JobDefinitionResource(jobDefinitionResource.getName(), PasswordUtils.maskPasswordsInDefinition(jobDefinitionResource.getDefinition()));
            maskedJobDefinitionResource.setStatus(jobDefinitionResource.getStatus());
            maskedContents.add(maskedJobDefinitionResource);
        }
        return new PagedResources(maskedContents, pagedResources.getMetadata(), (Iterable)pagedResources.getLinks());
    }

    @ResponseBody
    @RequestMapping(value={"/clean/rabbit/{job}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public Map<String, List<String>> clean(@PathVariable String job, @RequestParam(required=false) String adminUri, @RequestParam(required=false) String user, @RequestParam(required=false) String pw, @RequestParam(required=false) String vhost, @RequestParam(required=false) String busPrefix) {
        return this.cleanRabbitBus(job, adminUri, user, pw, vhost, busPrefix, true);
    }

    @Override
    protected JobDefinition createDefinition(String name, String definition) {
        return new JobDefinition(name, definition);
    }
}

