/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest;

import com.google.common.collect.Lists;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.xd.dirt.stream.DocumentParseResult;
import org.springframework.xd.dirt.stream.dsl.StreamDefinitionException;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.rest.domain.DocumentParseResultResource;
import org.springframework.xd.rest.domain.RESTModuleType;

public class DocumentParseResultResourceAssembler
implements ResourceAssembler<DocumentParseResult, DocumentParseResultResource> {
    public DocumentParseResultResource toResource(DocumentParseResult entity) {
        DocumentParseResultResource resource = new DocumentParseResultResource();
        for (DocumentParseResult.Line line : entity) {
            DocumentParseResultResource.Line resourceLine = new DocumentParseResultResource.Line();
            if (line.getExceptions() != null) {
                for (Exception e : line.getExceptions()) {
                    if (e instanceof StreamDefinitionException) {
                        StreamDefinitionException sde = (StreamDefinitionException)e;
                        resourceLine.addError(new DocumentParseResultResource.Error(sde.getMessage(), Integer.valueOf(sde.getPosition())));
                        continue;
                    }
                    resourceLine.addError(new DocumentParseResultResource.Error(e.getMessage()));
                }
            }
            if (line.getDescriptors() != null) {
                for (ModuleDescriptor md : Lists.reverse(line.getDescriptors())) {
                    resourceLine.addDescriptor(new DocumentParseResultResource.ModuleDescriptor(md.getGroup(), md.getModuleLabel(), RESTModuleType.valueOf((String)md.getType().name()), md.getModuleName(), md.getSourceChannelName(), md.getSinkChannelName(), md.getParameters()));
                }
            }
            resource.addLine(resourceLine);
        }
        return resource;
    }
}

