/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.stereotype.Component;
import org.springframework.xd.dirt.rest.ModulesController;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.info.ModuleInformation;
import org.springframework.xd.module.info.ModuleInformationResolver;
import org.springframework.xd.module.options.ModuleOption;
import org.springframework.xd.module.options.ModuleOptionsMetadata;
import org.springframework.xd.module.options.ModuleOptionsMetadataResolver;
import org.springframework.xd.module.options.PassthruModuleOptionsMetadata;
import org.springframework.xd.module.options.types.Password;
import org.springframework.xd.rest.domain.DetailedModuleDefinitionResource;

@Component
public class DetailedModuleDefinitionResourceAssembler
extends ResourceAssemblerSupport<ModuleDefinition, DetailedModuleDefinitionResource> {
    private ModuleOptionsMetadataResolver moduleOptionsMetadataResolver;
    private ModuleInformationResolver moduleInformationResolver;

    @Autowired
    public DetailedModuleDefinitionResourceAssembler(ModuleOptionsMetadataResolver moduleOptionsMetadataResolver, ModuleInformationResolver moduleInformationResolver) {
        super(ModulesController.class, DetailedModuleDefinitionResource.class);
        this.moduleOptionsMetadataResolver = moduleOptionsMetadataResolver;
        this.moduleInformationResolver = moduleInformationResolver;
    }

    public DetailedModuleDefinitionResource toResource(ModuleDefinition entity) {
        return (DetailedModuleDefinitionResource)this.createResourceWithId(entity.getType() + "/" + entity.getName(), entity);
    }

    protected DetailedModuleDefinitionResource instantiateResource(ModuleDefinition entity) {
        ModuleInformation moduleInformation;
        DetailedModuleDefinitionResource result = new DetailedModuleDefinitionResource(entity.getName(), entity.getType().name(), entity.isComposed());
        ModuleOptionsMetadata moduleOptionsMetadata = this.moduleOptionsMetadataResolver.resolve(entity);
        if (!(moduleOptionsMetadata instanceof PassthruModuleOptionsMetadata)) {
            for (ModuleOption option : moduleOptionsMetadata) {
                Object defaultValue = option.getDefaultValue();
                String type = option.getType();
                Object defaultValueAsString = Password.class.getName().equals(type) && defaultValue != null ? "******" : (defaultValue == null ? null : defaultValue.toString());
                result.addOption(new DetailedModuleDefinitionResource.Option(option.getName(), type == null ? null : type, option.getDescription(), (String)defaultValueAsString, option.isHidden()));
            }
        }
        if ((moduleInformation = this.moduleInformationResolver.resolve(entity)) != null) {
            result.setShortDescription(moduleInformation.getShortDescription());
        }
        return result;
    }
}

