/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest;

import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.xd.dirt.job.DetailedJobInfo;
import org.springframework.xd.dirt.job.JobExecutionInfo;
import org.springframework.xd.dirt.rest.BatchJobsController;
import org.springframework.xd.dirt.rest.JobExecutionInfoResourceAssembler;
import org.springframework.xd.rest.domain.DetailedJobInfoResource;
import org.springframework.xd.rest.domain.JobExecutionInfoResource;

public class DetailedJobInfoResourceAssembler
extends ResourceAssemblerSupport<DetailedJobInfo, DetailedJobInfoResource> {
    private JobExecutionInfoResourceAssembler jobExecutionInfoResourceAssembler = new JobExecutionInfoResourceAssembler();

    public DetailedJobInfoResourceAssembler() {
        super(BatchJobsController.class, DetailedJobInfoResource.class);
    }

    public DetailedJobInfoResource toResource(DetailedJobInfo entity) {
        return (DetailedJobInfoResource)this.createResourceWithId(entity.getName(), entity);
    }

    protected DetailedJobInfoResource instantiateResource(DetailedJobInfo entity) {
        JobExecutionInfoResource jobExecutionInfoResource;
        if (entity.getLastExecutionInfo() != null) {
            JobExecutionInfo jobExecutionInfo = new JobExecutionInfo(entity.getLastExecutionInfo().getJobExecution(), entity.getLastExecutionInfo().getTimeZone());
            jobExecutionInfoResource = this.jobExecutionInfoResourceAssembler.instantiateResource(jobExecutionInfo);
        } else {
            jobExecutionInfoResource = null;
        }
        return new DetailedJobInfoResource(entity.getName(), entity.getExecutionCount(), entity.isLaunchable(), entity.isIncrementable(), jobExecutionInfoResource, entity.isDeployed());
    }
}

