/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest;

import java.io.Serializable;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.xd.dirt.cluster.Container;
import org.springframework.xd.dirt.cluster.ContainerShutdownException;
import org.springframework.xd.dirt.cluster.ModuleMessageRateNotFoundException;
import org.springframework.xd.dirt.cluster.NoSuchContainerException;
import org.springframework.xd.dirt.container.store.ContainerRepository;
import org.springframework.xd.dirt.container.store.DetailedContainer;
import org.springframework.xd.dirt.rest.RuntimeContainerResourceAssembler;
import org.springframework.xd.rest.domain.DetailedContainerResource;

@Controller
@RequestMapping(value={"/runtime/containers"})
@ExposesResourceFor(value=DetailedContainerResource.class)
public class ContainersController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ContainerRepository containerRepository;
    private ResourceAssemblerSupport<DetailedContainer, DetailedContainerResource> resourceAssembler = new RuntimeContainerResourceAssembler();
    private RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory());
    @Value(value="${management.contextPath:/management}")
    private String managementContextPath;
    @Value(value="${xd.messageRateMonitoring.enabled:false}")
    private String enableMessageRates;
    private static final String CONTAINER_HOST_URI_PROTOCOL = "http://";
    private static final String SHUTDOWN_ENDPOINT = "/shutdown";
    private static final String JOLOKIA_XD_MODULE_MBEAN_URL = "/management/jolokia/read/xd.*:module=*,component=*,name=*";
    private static final String INPUT_CHANNEL_NAME = "input";
    private static final String OUTPUT_CHANNEL_NAME = "output";

    @Autowired
    public ContainersController(ContainerRepository containerRepository) {
        this.containerRepository = containerRepository;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public PagedResources<DetailedContainerResource> list(Pageable pageable, PagedResourcesAssembler<DetailedContainer> assembler) throws ModuleMessageRateNotFoundException {
        Page<DetailedContainer> containers = this.containerRepository.findAllRuntimeContainers(pageable, true);
        for (DetailedContainer container : containers) {
            if (container.getDeployedModules().isEmpty()) continue;
            this.setMessageRates(container);
        }
        return assembler.toResource(containers, this.resourceAssembler);
    }

    private void setMessageRates(DetailedContainer container) {
        String containerHost = container.getAttributes().getIp();
        String containerManagementPort = container.getAttributes().getManagementPort();
        if (StringUtils.hasText((String)containerManagementPort) && this.enableMessageRates.equalsIgnoreCase("true")) {
            HashMap<String, HashMap<String, Double>> messageRates = new HashMap<String, HashMap<String, Double>>();
            String request = String.format("%s%s:%s%s", CONTAINER_HOST_URI_PROTOCOL, containerHost, containerManagementPort, JOLOKIA_XD_MODULE_MBEAN_URL);
            try {
                String response = ((String)this.restTemplate.getForObject(request, String.class, new Object[0])).toString();
                JSONObject jObject = new JSONObject(response);
                JSONObject value = jObject.getJSONObject("value");
                JSONArray jsonArray = value.names();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    String mbeanKey = (String)jsonArray.get(i);
                    StringTokenizer tokenizer = new StringTokenizer(mbeanKey, ",");
                    if (!mbeanKey.contains("component=MessageChannel") || !mbeanKey.contains("name=input") && !mbeanKey.contains("name=output")) continue;
                    while (tokenizer.hasMoreElements()) {
                        String element = (String)tokenizer.nextElement();
                        if (!element.startsWith("module=")) continue;
                        String key = String.format("%s", element.substring(element.indexOf("=") + 1));
                        HashMap rate = messageRates.get(key) != null ? (HashMap)messageRates.get(key) : new HashMap();
                        Double rateValue = (Double)value.getJSONObject((String)jsonArray.get(i)).get("MeanSendRate");
                        if (mbeanKey.contains("name=input")) {
                            rate.put(INPUT_CHANNEL_NAME, rateValue);
                        } else if (mbeanKey.contains("name=output")) {
                            rate.put(OUTPUT_CHANNEL_NAME, rateValue);
                        }
                        messageRates.put(key, rate);
                    }
                }
                container.setMessageRates(messageRates);
            }
            catch (RestClientException e) {
                this.logger.warn(String.format("Error getting message rate metrics for %s", container.getName()), (Throwable)e);
            }
            catch (JSONException jse) {
                this.logger.warn(String.format("Error getting message rate metrics for %s", container.getName()), (Throwable)jse);
            }
        }
    }

    @RequestMapping(value={""}, method={RequestMethod.DELETE}, params={"containerId"})
    @ResponseStatus(value=HttpStatus.OK)
    public void shutdownContainer(String containerId) throws NoSuchContainerException, ContainerShutdownException {
        Container container = (Container)this.containerRepository.findOne((Serializable)((Object)containerId));
        if (container != null) {
            String containerHost = container.getAttributes().getIp();
            String containerManagementPort = container.getAttributes().getManagementPort();
            RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory());
            try {
                restTemplate.postForObject(CONTAINER_HOST_URI_PROTOCOL + containerHost + ":" + containerManagementPort + this.managementContextPath + SHUTDOWN_ENDPOINT, Object.class, Object.class, new Object[0]);
            }
            catch (RestClientException e) {
                throw new ContainerShutdownException(e.getMessage());
            }
        } else {
            throw new NoSuchContainerException("Container could not be found with id " + containerId);
        }
    }
}

