/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.batch.admin.history.StepExecutionHistory;
import org.springframework.batch.core.StepExecution;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.xd.dirt.job.NoSuchJobExecutionException;
import org.springframework.xd.dirt.job.NoSuchStepExecutionException;
import org.springframework.xd.dirt.job.StepExecutionInfo;
import org.springframework.xd.dirt.job.StepExecutionProgressInfo;
import org.springframework.xd.dirt.rest.AbstractBatchJobsController;
import org.springframework.xd.rest.domain.StepExecutionInfoResource;
import org.springframework.xd.rest.domain.StepExecutionProgressInfoResource;

@RestController
@RequestMapping(value={"/jobs/executions/{jobExecutionId}/steps"})
@ExposesResourceFor(value=StepExecutionInfoResource.class)
public class BatchStepExecutionsController
extends AbstractBatchJobsController {
    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Collection<StepExecutionInfoResource> list(@PathVariable(value="jobExecutionId") long jobExecutionId) {
        Collection stepExecutions;
        try {
            stepExecutions = this.jobService.getStepExecutions(jobExecutionId);
        }
        catch (org.springframework.batch.core.launch.NoSuchJobExecutionException e) {
            throw new NoSuchJobExecutionException(jobExecutionId);
        }
        ArrayList<StepExecutionInfoResource> result = new ArrayList<StepExecutionInfoResource>();
        for (StepExecution stepExecution : stepExecutions) {
            if (stepExecution.getId() == null) continue;
            result.add(this.stepExecutionInfoResourceAssembler.toResource(new StepExecutionInfo(stepExecution, this.timeZone)));
        }
        return result;
    }

    @RequestMapping(value={"/{stepExecutionId}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public StepExecutionInfoResource details(@PathVariable long jobExecutionId, @PathVariable long stepExecutionId) {
        try {
            StepExecution stepExecution = this.jobService.getStepExecution(jobExecutionId, stepExecutionId);
            return this.stepExecutionInfoResourceAssembler.toResource(new StepExecutionInfo(stepExecution, this.timeZone));
        }
        catch (org.springframework.batch.admin.service.NoSuchStepExecutionException e) {
            throw new NoSuchStepExecutionException(stepExecutionId);
        }
        catch (org.springframework.batch.core.launch.NoSuchJobExecutionException e) {
            throw new NoSuchJobExecutionException(jobExecutionId);
        }
    }

    @RequestMapping(value={"/{stepExecutionId}/progress"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public StepExecutionProgressInfoResource progress(@PathVariable long jobExecutionId, @PathVariable long stepExecutionId) {
        try {
            StepExecution stepExecution = this.jobService.getStepExecution(jobExecutionId, stepExecutionId);
            String stepName = stepExecution.getStepName();
            if (stepName.contains(":partition")) {
                stepName = stepName.replaceAll("(:partition).*", "$1*");
            }
            String jobName = stepExecution.getJobExecution().getJobInstance().getJobName();
            StepExecutionHistory stepExecutionHistory = this.computeHistory(jobName, stepName);
            return this.progressInfoResourceAssembler.toResource(new StepExecutionProgressInfo(stepExecution, stepExecutionHistory));
        }
        catch (org.springframework.batch.admin.service.NoSuchStepExecutionException e) {
            throw new NoSuchStepExecutionException(stepExecutionId);
        }
        catch (org.springframework.batch.core.launch.NoSuchJobExecutionException e) {
            throw new NoSuchJobExecutionException(jobExecutionId);
        }
    }

    private StepExecutionHistory computeHistory(String jobName, String stepName) {
        int total = this.jobService.countStepExecutionsForStep(jobName, stepName);
        StepExecutionHistory stepExecutionHistory = new StepExecutionHistory(stepName);
        for (int i = 0; i < total; i += 1000) {
            for (StepExecution stepExecution : this.jobService.listStepExecutionsForStep(jobName, stepName, i, 1000)) {
                stepExecutionHistory.append(stepExecution);
            }
        }
        return stepExecutionHistory;
    }
}

