/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.xd.dirt.job.DetailedJobInfo;
import org.springframework.xd.dirt.job.JobExecutionInfo;
import org.springframework.xd.dirt.rest.AbstractBatchJobsController;
import org.springframework.xd.dirt.stream.Job;
import org.springframework.xd.dirt.stream.JobDefinition;
import org.springframework.xd.rest.domain.DetailedJobInfoResource;

@RestController
@RequestMapping(value={"/jobs/configurations"})
@ExposesResourceFor(value=DetailedJobInfoResource.class)
public class BatchJobsController
extends AbstractBatchJobsController {
    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public PagedResources<DetailedJobInfoResource> jobs(Pageable pageable, PagedResourcesAssembler<DetailedJobInfo> assembler) {
        Page deployedJobs = this.xdJobrepository.findAll(pageable);
        ArrayList<DetailedJobInfo> detailedJobs = new ArrayList<DetailedJobInfo>();
        for (Job deployedJob : deployedJobs) {
            DetailedJobInfo detailedJobInfo = this.getJobInfo(((JobDefinition)deployedJob.getDefinition()).getName(), true);
            if (detailedJobInfo == null) continue;
            detailedJobs.add(detailedJobInfo);
        }
        return assembler.toResource((Page)new PageImpl(detailedJobs, pageable, deployedJobs.getTotalElements()), (ResourceAssembler)this.jobInfoResourceAssembler);
    }

    @RequestMapping(value={"/{jobName}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public DetailedJobInfoResource jobinfo(@PathVariable String jobName) {
        return this.getJobInfoResource(jobName);
    }

    private DetailedJobInfoResource getJobInfoResource(String jobName) {
        Job deployedJob = (Job)this.xdJobrepository.findOne((Serializable)((Object)jobName));
        DetailedJobInfo detailedJobInfo = this.getJobInfo(jobName, null != deployedJob);
        return detailedJobInfo != null ? this.jobInfoResourceAssembler.instantiateResource(detailedJobInfo) : null;
    }

    private DetailedJobInfo getJobInfo(String jobName, boolean deployed) {
        boolean launchable = this.jobService.isLaunchable(jobName);
        try {
            int count = this.jobService.countJobExecutionsForJob(jobName);
            return new DetailedJobInfo(jobName, count, launchable, this.jobService.isIncrementable(jobName), this.getLastExecution(jobName), deployed);
        }
        catch (NoSuchJobException e) {
            return null;
        }
    }

    private JobExecutionInfo getLastExecution(String jobName) throws NoSuchJobException {
        Collection executions = this.jobService.listJobExecutionsForJob(jobName, 0, 1);
        if (executions.size() > 0) {
            return new JobExecutionInfo((JobExecution)executions.iterator().next(), this.timeZone);
        }
        return null;
    }
}

