/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.launch.NoSuchJobInstanceException;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.xd.dirt.job.JobExecutionInfo;
import org.springframework.xd.dirt.job.JobInstanceInfo;
import org.springframework.xd.dirt.job.NoSuchBatchJobException;
import org.springframework.xd.dirt.job.NoSuchBatchJobInstanceException;
import org.springframework.xd.dirt.rest.AbstractBatchJobsController;
import org.springframework.xd.rest.domain.JobInstanceInfoResource;

@RestController
@RequestMapping(value={"/jobs/instances"})
@ExposesResourceFor(value=JobInstanceInfoResource.class)
public class BatchJobInstancesController
extends AbstractBatchJobsController {
    @RequestMapping(value={"/{instanceId}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public JobInstanceInfoResource getJobInstance(@PathVariable long instanceId) {
        try {
            JobInstance jobInstance = this.jobService.getJobInstance(instanceId);
            String jobName = jobInstance.getJobName();
            try {
                List jobExecutions = (List)this.jobService.getJobExecutionsForJobInstance(jobInstance.getJobName(), jobInstance.getId());
                ArrayList<JobExecutionInfo> jobExecutionInfos = new ArrayList<JobExecutionInfo>();
                for (JobExecution jobExecution : jobExecutions) {
                    jobExecutionInfos.add(new JobExecutionInfo(jobExecution, this.timeZone));
                }
                return this.jobInstanceInfoResourceAssembler.toResource(new JobInstanceInfo(jobInstance, jobExecutionInfos));
            }
            catch (NoSuchJobException e) {
                throw new NoSuchBatchJobException(jobName);
            }
        }
        catch (NoSuchJobInstanceException e) {
            throw new NoSuchBatchJobInstanceException(instanceId);
        }
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, params={"jobname"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Collection<JobInstanceInfoResource> instancesForJob(@RequestParam(value="jobname") String jobName, @RequestParam(defaultValue="0") int startJobInstance, @RequestParam(defaultValue="20") int pageSize) {
        try {
            Collection jobInstances = this.jobService.listJobInstances(jobName, startJobInstance, pageSize);
            ArrayList<JobInstanceInfoResource> result = new ArrayList<JobInstanceInfoResource>();
            for (JobInstance jobInstance : jobInstances) {
                List jobExecutions = (List)this.jobService.getJobExecutionsForJobInstance(jobName, jobInstance.getId());
                ArrayList<JobExecutionInfo> jobExecutionInfos = new ArrayList<JobExecutionInfo>();
                for (JobExecution jobExecution : jobExecutions) {
                    jobExecutionInfos.add(new JobExecutionInfo(jobExecution, this.timeZone));
                }
                result.add(this.jobInstanceInfoResourceAssembler.toResource(new JobInstanceInfo(jobInstance, jobExecutionInfos)));
            }
            return result;
        }
        catch (NoSuchJobException e) {
            throw new NoSuchBatchJobException(jobName);
        }
    }
}

