/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.launch.JobExecutionNotRunningException;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.launch.NoSuchJobExecutionException;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.xd.dirt.job.JobExecutionAlreadyRunningException;
import org.springframework.xd.dirt.job.JobExecutionInfo;
import org.springframework.xd.dirt.job.JobInstanceAlreadyCompleteException;
import org.springframework.xd.dirt.job.JobParametersInvalidException;
import org.springframework.xd.dirt.job.JobRestartException;
import org.springframework.xd.dirt.job.NoSuchBatchJobException;
import org.springframework.xd.dirt.plugins.job.DistributedJobLocator;
import org.springframework.xd.dirt.plugins.job.ExpandedJobParametersConverter;
import org.springframework.xd.dirt.rest.AbstractBatchJobsController;
import org.springframework.xd.dirt.stream.JobDefinition;
import org.springframework.xd.dirt.stream.JobDeployer;
import org.springframework.xd.rest.domain.JobExecutionInfoResource;

@RestController
@RequestMapping(value={"/jobs/executions"})
@ExposesResourceFor(value=JobExecutionInfoResource.class)
public class BatchJobExecutionsController
extends AbstractBatchJobsController {
    @Autowired
    private JobDeployer jobDeployer;
    @Autowired
    private DistributedJobLocator jobLocator;
    @Autowired
    private StepExecutionDao stepExecutionDao;

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public PagedResources<JobExecutionInfoResource> list(Pageable pageable) {
        ArrayList<JobExecutionInfoResource> resources = new ArrayList<JobExecutionInfoResource>();
        HashSet<String> restartableJobs = new HashSet<String>(this.jobLocator.getAllRestartableJobs());
        HashSet<String> deployedJobs = new HashSet<String>(this.jobLocator.getJobNames());
        HashSet<String> jobDefinitionNames = new HashSet<String>(this.getJobDefinitionNames());
        for (JobExecution jobExecution : this.jobService.getTopLevelJobExecutions(pageable.getOffset(), pageable.getPageSize())) {
            this.stepExecutionDao.addStepExecutions(jobExecution);
            JobExecutionInfoResource jobExecutionInfoResource = this.getJobExecutionInfoResource(jobExecution, restartableJobs, deployedJobs, jobDefinitionNames);
            boolean isComposed = this.jobService.isComposedJobExecution(jobExecution.getId());
            jobExecutionInfoResource.setComposedJob(isComposed);
            resources.add(jobExecutionInfoResource);
        }
        PagedResources pagedResources = new PagedResources(resources, new PagedResources.PageMetadata((long)pageable.getPageSize(), (long)pageable.getPageNumber(), Long.valueOf(this.jobService.countTopLevelJobExecutions()).longValue()), new Link[0]);
        return pagedResources;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, params={"jobname"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Collection<JobExecutionInfoResource> executionsForJob(@RequestParam(value="jobname") String jobName, @RequestParam(defaultValue="0") int startJobExecution, @RequestParam(defaultValue="20") int pageSize) {
        ArrayList<JobExecutionInfoResource> result = new ArrayList<JobExecutionInfoResource>();
        try {
            for (JobExecution jobExecution : this.jobService.listJobExecutionsForJob(jobName, startJobExecution, pageSize)) {
                result.add(this.jobExecutionInfoResourceAssembler.toResource(new JobExecutionInfo(jobExecution, this.timeZone)));
            }
        }
        catch (NoSuchJobException e) {
            throw new NoSuchBatchJobException(jobName);
        }
        return result;
    }

    @RequestMapping(value={""}, method={RequestMethod.POST}, params={"jobname"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void launchJob(@RequestParam(value="jobname") String name, @RequestParam(required=false) String jobParameters) {
        this.jobDeployer.launch(name, jobParameters);
    }

    private Collection<String> getJobDefinitionNames() {
        ArrayList<String> jobDefinitionNames = new ArrayList<String>();
        Iterable jobDefinitions = this.xdJobDefinitionRepository.findAll();
        for (JobDefinition definition : jobDefinitions) {
            jobDefinitionNames.add(definition.getName());
        }
        return jobDefinitionNames;
    }

    private boolean isJobExecutionRestartable(JobExecution jobExecution) {
        JobInstance jobInstance = jobExecution.getJobInstance();
        BatchStatus status = jobExecution.getStatus();
        try {
            List jobExecutionsForJobInstance = (List)this.jobService.getJobExecutionsForJobInstance(jobInstance.getJobName(), jobInstance.getId());
            for (JobExecution jobExecutionForJobInstance : jobExecutionsForJobInstance) {
                if (jobExecutionForJobInstance.getStatus() != BatchStatus.COMPLETED) continue;
                return false;
            }
        }
        catch (NoSuchJobException e) {
            throw new NoSuchBatchJobException(jobInstance.getJobName());
        }
        return status.isGreaterThan(BatchStatus.STOPPING) && status.isLessThan(BatchStatus.ABANDONED);
    }

    @RequestMapping(value={"/{executionId}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public JobExecutionInfoResource getJobExecutionInfo(@PathVariable long executionId) {
        JobExecution jobExecution;
        try {
            jobExecution = this.jobService.getJobExecution(executionId);
        }
        catch (NoSuchJobExecutionException e) {
            throw new org.springframework.xd.dirt.job.NoSuchJobExecutionException(executionId);
        }
        HashSet<String> restartableJobs = new HashSet<String>(this.jobLocator.getAllRestartableJobs());
        HashSet<String> deployedJobs = new HashSet<String>(this.jobLocator.getJobNames());
        HashSet<String> jobDefinitionNames = new HashSet<String>(this.getJobDefinitionNames());
        JobExecutionInfoResource jobExecutionInfoResource = this.getJobExecutionInfoResource(jobExecution, restartableJobs, deployedJobs, jobDefinitionNames);
        for (JobExecution childJobExecution : this.jobService.getChildJobExecutions(jobExecution.getId())) {
            jobExecutionInfoResource.setComposedJob(true);
            this.stepExecutionDao.addStepExecutions(childJobExecution);
            JobExecutionInfoResource childJobExecutionInfoResource = this.getJobExecutionInfoResource(childJobExecution, restartableJobs, deployedJobs, jobDefinitionNames);
            boolean isComposed = this.jobService.isComposedJobExecution(childJobExecution.getId());
            childJobExecutionInfoResource.setComposedJob(isComposed);
            jobExecutionInfoResource.getChildJobExecutions().add(childJobExecutionInfoResource);
        }
        return jobExecutionInfoResource;
    }

    private JobExecutionInfoResource getJobExecutionInfoResource(JobExecution jobExecution, Set<String> restartableJobs, Set<String> deployedJobs, Set<String> jobDefinitionNames) {
        JobExecutionInfoResource jobExecutionInfoResource = this.jobExecutionInfoResourceAssembler.toResource(new JobExecutionInfo(jobExecution, this.timeZone));
        String jobName = jobExecution.getJobInstance().getJobName();
        jobExecutionInfoResource.setDeleted(!jobDefinitionNames.contains(jobName));
        jobExecutionInfoResource.setDeployed(deployedJobs.contains(jobName));
        if (restartableJobs.contains(jobName)) {
            if (jobExecution.getStatus() != BatchStatus.COMPLETED) {
                jobExecutionInfoResource.setRestartable(this.isJobExecutionRestartable(jobExecution));
            }
        } else {
            jobExecutionInfoResource.setRestartable(false);
        }
        return jobExecutionInfoResource;
    }

    @RequestMapping(value={"/{executionId}"}, method={RequestMethod.PUT}, params={"stop=true"})
    @ResponseStatus(value=HttpStatus.OK)
    public void stopJobExecution(@PathVariable(value="executionId") long jobExecutionId) {
        try {
            this.jobService.stop(jobExecutionId);
        }
        catch (JobExecutionNotRunningException e) {
            throw new org.springframework.xd.dirt.job.JobExecutionNotRunningException(jobExecutionId);
        }
        catch (NoSuchJobExecutionException e) {
            throw new org.springframework.xd.dirt.job.NoSuchJobExecutionException(jobExecutionId);
        }
    }

    @RequestMapping(value={"/{executionId}"}, method={RequestMethod.PUT}, params={"restart=true"})
    @ResponseStatus(value=HttpStatus.OK)
    public void restartJobExecution(@PathVariable(value="executionId") long jobExecutionId) {
        Job job;
        JobExecution jobExecution;
        try {
            jobExecution = this.jobService.getJobExecution(jobExecutionId);
        }
        catch (NoSuchJobExecutionException e) {
            throw new org.springframework.xd.dirt.job.NoSuchJobExecutionException(jobExecutionId);
        }
        if (jobExecution.isRunning()) {
            throw new JobExecutionAlreadyRunningException("Job Execution for this job is already running: " + jobExecution.getJobInstance());
        }
        JobInstance lastInstance = jobExecution.getJobInstance();
        ExpandedJobParametersConverter expandedJobParametersConverter = new ExpandedJobParametersConverter();
        JobParameters jobParameters = jobExecution.getJobParameters();
        try {
            job = this.jobLocator.getJob(lastInstance.getJobName());
        }
        catch (NoSuchJobException e1) {
            throw new NoSuchBatchJobException("The job '" + lastInstance.getJobName() + "' does not exist.");
        }
        try {
            job.getJobParametersValidator().validate(jobParameters);
        }
        catch (org.springframework.batch.core.JobParametersInvalidException e) {
            throw new JobParametersInvalidException("The Job Parameters for Job Execution " + jobExecution.getId() + " are invalid.");
        }
        BatchStatus status = jobExecution.getStatus();
        if (status == BatchStatus.COMPLETED || status == BatchStatus.ABANDONED) {
            throw new JobInstanceAlreadyCompleteException("Job Execution " + jobExecution.getId() + " is already complete.");
        }
        if (!job.isRestartable()) {
            throw new JobRestartException("The job '" + lastInstance.getJobName() + "' is not restartable.");
        }
        String jobParametersAsString = expandedJobParametersConverter.getJobParametersAsString(jobParameters, true);
        this.jobDeployer.launch(lastInstance.getJobName(), jobParametersAsString);
    }

    @RequestMapping(value={""}, method={RequestMethod.PUT}, params={"stop=true"})
    @ResponseStatus(value=HttpStatus.OK)
    public void stopAll() {
        this.jobService.stopAll();
    }
}

