/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.hateoas.UriTemplate;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.xd.dirt.rest.CompletionsController;
import org.springframework.xd.rest.domain.CompletionKind;
import org.springframework.xd.rest.domain.DetailedContainerResource;
import org.springframework.xd.rest.domain.DetailedJobInfoResource;
import org.springframework.xd.rest.domain.JobDefinitionResource;
import org.springframework.xd.rest.domain.JobExecutionInfoResource;
import org.springframework.xd.rest.domain.JobInstanceInfoResource;
import org.springframework.xd.rest.domain.ModuleDefinitionResource;
import org.springframework.xd.rest.domain.ModuleMetadataResource;
import org.springframework.xd.rest.domain.StreamDefinitionResource;
import org.springframework.xd.rest.domain.XDRuntime;
import org.springframework.xd.rest.domain.meta.VersionResource;
import org.springframework.xd.rest.domain.metrics.AggregateCountsResource;
import org.springframework.xd.rest.domain.metrics.CounterResource;
import org.springframework.xd.rest.domain.metrics.FieldValueCounterResource;
import org.springframework.xd.rest.domain.metrics.GaugeResource;
import org.springframework.xd.rest.domain.metrics.RichGaugeResource;
import org.springframework.xd.rest.domain.security.SecurityInfoResource;

@Controller
@RequestMapping(value={"/"})
public class AdminController {
    private final EntityLinks entityLinks;

    @Autowired
    public AdminController(EntityLinks entityLinks) {
        this.entityLinks = entityLinks;
    }

    @RequestMapping
    @ResponseBody
    public XDRuntime info() {
        XDRuntime xdRuntime = new XDRuntime();
        xdRuntime.add(this.entityLinks.linkFor(StreamDefinitionResource.class).withRel("streams"));
        xdRuntime.add(this.entityLinks.linkFor(JobDefinitionResource.class).withRel("jobs"));
        xdRuntime.add(this.entityLinks.linkFor(ModuleDefinitionResource.class).withRel("modules"));
        xdRuntime.add(this.entityLinks.linkFor(SecurityInfoResource.class).withRel("security/info"));
        xdRuntime.add(this.entityLinks.linkFor(ModuleMetadataResource.class).withRel("runtime/modules"));
        xdRuntime.add(this.entityLinks.linkFor(DetailedContainerResource.class).withRel("runtime/containers"));
        xdRuntime.add(this.entityLinks.linkFor(DetailedJobInfoResource.class).withRel("jobs/configurations"));
        xdRuntime.add(this.entityLinks.linkFor(JobExecutionInfoResource.class).withRel("jobs/executions"));
        xdRuntime.add(this.entityLinks.linkFor(JobInstanceInfoResource.class).withRel("jobs/instances"));
        xdRuntime.add(this.entityLinks.linkFor(VersionResource.class).withRel("meta/version"));
        TemplateVariable start = new TemplateVariable("start", TemplateVariable.VariableType.REQUEST_PARAM);
        TemplateVariable lod = new TemplateVariable("detailLevel", TemplateVariable.VariableType.REQUEST_PARAM_CONTINUED);
        TemplateVariables vars = new TemplateVariables(new TemplateVariable[]{start, lod});
        for (CompletionKind k : CompletionKind.values()) {
            List<String> mi = ((CompletionsController)ControllerLinkBuilder.methodOn(CompletionsController.class, (Object[])new Object[0])).completions(k, "", 42);
            Link link = ControllerLinkBuilder.linkTo(mi).withRel(String.format("completions/%s", k));
            String href = link.getHref().substring(0, link.getHref().lastIndexOf(63));
            UriTemplate template = new UriTemplate(href, vars);
            Link copy = new Link(template, link.getRel());
            xdRuntime.add(copy);
        }
        xdRuntime.add(this.entityLinks.linkFor(CounterResource.class).withRel("counters"));
        xdRuntime.add(this.entityLinks.linkFor(FieldValueCounterResource.class).withRel("field-value-counters"));
        xdRuntime.add(this.entityLinks.linkFor(AggregateCountsResource.class).withRel("aggregate-counters"));
        xdRuntime.add(this.entityLinks.linkFor(GaugeResource.class).withRel("gauges"));
        xdRuntime.add(this.entityLinks.linkFor(RichGaugeResource.class).withRel("rich-gauges"));
        return xdRuntime;
    }
}

