/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.rest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

class AccessControlInterceptor
extends HandlerInterceptorAdapter {
    private static final String LOCATION = "Location";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    private static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    private static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    private static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    private static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    private static final String CACHE_SECONDS = "300";
    private final String allowedOrigin;

    AccessControlInterceptor(String allowedOrigin) {
        Assert.hasText((String)allowedOrigin);
        this.allowedOrigin = allowedOrigin;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String acRequestMethod = request.getHeader(ACCESS_CONTROL_REQUEST_METHOD);
        String acRequestHeaders = request.getHeader(ACCESS_CONTROL_REQUEST_HEADERS);
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, this.allowedOrigin);
        if (HttpMethod.OPTIONS.toString().equals(request.getMethod()) && this.hasValue(acRequestMethod)) {
            response.addHeader(ACCESS_CONTROL_ALLOW_METHODS, HttpMethod.GET.toString());
            response.addHeader(ACCESS_CONTROL_ALLOW_METHODS, HttpMethod.POST.toString());
            response.addHeader(ACCESS_CONTROL_ALLOW_METHODS, HttpMethod.PUT.toString());
            response.addHeader(ACCESS_CONTROL_ALLOW_METHODS, HttpMethod.DELETE.toString());
            response.setHeader(ACCESS_CONTROL_ALLOW_HEADERS, acRequestHeaders);
            response.setHeader(ACCESS_CONTROL_MAX_AGE, CACHE_SECONDS);
            return false;
        }
        response.addHeader(ACCESS_CONTROL_EXPOSE_HEADERS, LOCATION);
        return true;
    }

    private boolean hasValue(String s) {
        return s != null && !s.isEmpty();
    }
}

