/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins.stream;

import java.util.Properties;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.integration.bus.MessageBus;
import org.springframework.xd.dirt.integration.bus.MessageBusAwareRouterBeanPostProcessor;
import org.springframework.xd.dirt.plugins.AbstractStreamPlugin;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;
import org.springframework.xd.module.ModuleType;
import org.springframework.xd.module.core.Module;

public class StreamPlugin
extends AbstractStreamPlugin {
    @Autowired
    public StreamPlugin(MessageBus messageBus, ZooKeeperConnection zkConnection) {
        super(messageBus, zkConnection);
        Assert.notNull((Object)zkConnection, (String)"ZooKeeperConnection must not be null");
    }

    @Override
    public void preProcessModule(final Module module) {
        Properties properties = new Properties();
        properties.setProperty("xd.stream.name", module.getDescriptor().getGroup());
        module.addProperties(properties);
        if (module.getType() == ModuleType.sink) {
            module.addListener((ApplicationListener)new ApplicationListener<ApplicationPreparedEvent>(){

                public void onApplicationEvent(ApplicationPreparedEvent event) {
                    Properties producerProperties = StreamPlugin.this.extractConsumerProducerProperties(module)[1];
                    MessageBusAwareRouterBeanPostProcessor bpp = new MessageBusAwareRouterBeanPostProcessor(StreamPlugin.this.messageBus, producerProperties);
                    bpp.setBeanFactory((BeanFactory)event.getApplicationContext().getBeanFactory());
                    event.getApplicationContext().getBeanFactory().addBeanPostProcessor((BeanPostProcessor)bpp);
                }
            });
        }
    }

    @Override
    public void postProcessModule(Module module) {
        this.bindConsumerAndProducers(module);
    }

    @Override
    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

