/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins.stream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;
import org.springframework.xd.dirt.integration.bus.converter.CompositeMessageConverterFactory;
import org.springframework.xd.dirt.integration.bus.converter.ConversionException;
import org.springframework.xd.dirt.integration.bus.converter.MessageConverterUtils;
import org.springframework.xd.dirt.plugins.ModuleConfigurationException;
import org.springframework.xd.module.core.Module;
import org.springframework.xd.module.core.SimpleModule;

public class ModuleTypeConversionSupport {
    private static final Logger logger = LoggerFactory.getLogger(ModuleTypeConversionSupport.class);
    private final CompositeMessageConverterFactory converterFactory;
    private static final String INPUT_TYPE = "inputType";
    private static final String OUTPUT_TYPE = "outputType";

    public ModuleTypeConversionSupport(CompositeMessageConverterFactory converterFactory) {
        this.converterFactory = converterFactory;
    }

    public static MimeType getInputMimeType(Module module) {
        String contentTypeString = module.getProperties().getProperty(INPUT_TYPE);
        return ModuleTypeConversionSupport.getMimeType(contentTypeString, module);
    }

    public static MimeType getOutputMimeType(Module module) {
        String contentTypeString = module.getProperties().getProperty(OUTPUT_TYPE);
        return ModuleTypeConversionSupport.getMimeType(contentTypeString, module);
    }

    private static MimeType getMimeType(String contentTypeString, Module module) {
        MimeType mimeType = null;
        if (StringUtils.hasText((String)contentTypeString)) {
            try {
                mimeType = ModuleTypeConversionSupport.resolveContentType(contentTypeString, module);
            }
            catch (ClassNotFoundException cfe) {
                throw new IllegalArgumentException("Could not find the class required for " + contentTypeString, cfe);
            }
        }
        return mimeType;
    }

    protected void configureModuleInputChannelMessageConverters(Module module) {
        MimeType contentType = ModuleTypeConversionSupport.getInputMimeType(module);
        if (contentType != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("configuring message converters for module " + module.getName() + "'s input channel.  " + "Type is " + contentType);
            }
            Assert.isTrue((boolean)(module instanceof SimpleModule), (String)("Module should be an instance of " + SimpleModule.class.getName()));
            SimpleModule sm = (SimpleModule)module;
            try {
                AbstractMessageChannel channel = this.getChannel(module, true);
                this.configureMessageConverters(channel, contentType, sm.getApplicationContext().getClassLoader());
            }
            catch (Exception e) {
                throw new ModuleConfigurationException(e.getMessage(), e);
            }
        }
    }

    protected void configureModuleOutputChannelMessageConverters(Module module) {
        MimeType contentType = ModuleTypeConversionSupport.getOutputMimeType(module);
        if (contentType != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("configuring message converters for module " + module.getName() + "'s output channel.  " + "Type is " + contentType);
            }
            SimpleModule sm = (SimpleModule)module;
            try {
                AbstractMessageChannel channel = this.getChannel(module, false);
                this.configureMessageConverters(channel, contentType, sm.getApplicationContext().getClassLoader());
            }
            catch (Exception e) {
                throw new ModuleConfigurationException(e.getMessage(), e);
            }
        }
    }

    public void configureMessageConverters(AbstractMessageChannel channel, MimeType contentType, ClassLoader classLoader) {
        CompositeMessageConverter converters = null;
        try {
            converters = this.converterFactory.newInstance(contentType);
        }
        catch (ConversionException e) {
            throw new ModuleConfigurationException(e.getMessage() + "(" + channel.getComponentName() + "Type=" + contentType + ")");
        }
        Class<?> dataType = MessageConverterUtils.getJavaTypeForContentType(contentType, classLoader);
        if (dataType == null) {
            throw new ModuleConfigurationException("Content type is not supported for " + channel.getComponentName() + "Type=" + contentType);
        }
        channel.setDatatypes(new Class[]{dataType});
        channel.setMessageConverter((MessageConverter)converters);
    }

    private AbstractMessageChannel getChannel(Module module, boolean isInput) throws Exception {
        String name = isInput ? "input" : "output";
        Object channel = module.getComponent(name, Object.class);
        if (AopUtils.isJdkDynamicProxy((Object)channel)) {
            return (AbstractMessageChannel)((Advised)channel).getTargetSource().getTarget();
        }
        return (AbstractMessageChannel)channel;
    }

    public static MimeType resolveContentType(String type, Module module) throws ClassNotFoundException, LinkageError {
        if (!type.contains("/")) {
            Class<?> javaType = ModuleTypeConversionSupport.resolveJavaType(type, module);
            return MessageConverterUtils.javaObjectMimeType(javaType);
        }
        return MimeType.valueOf((String)type);
    }

    private static Class<?> resolveJavaType(String type, Module module) throws ClassNotFoundException, LinkageError {
        Assert.isTrue((boolean)(module instanceof SimpleModule), (String)("Module should be an instance of " + SimpleModule.class.getName()));
        SimpleModule sm = (SimpleModule)module;
        return ClassUtils.forName((String)type, (ClassLoader)sm.getApplicationContext().getClassLoader());
    }
}

