/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins.stream;

import java.util.ArrayList;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.util.MimeType;
import org.springframework.xd.dirt.plugins.stream.CustomMimeTypeConverter;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.ModuleType;
import org.springframework.xd.module.options.FlattenedCompositeModuleOptionsMetadata;
import org.springframework.xd.module.options.ModuleOptionsMetadata;
import org.springframework.xd.module.options.ModuleOptionsMetadataResolver;
import org.springframework.xd.module.options.PojoModuleOptionsMetadata;
import org.springframework.xd.module.options.spi.ModuleOption;

public class ModuleTypeConversionPluginMetadataResolver
implements ModuleOptionsMetadataResolver {
    private final GenericConversionService conversionService = new GenericConversionService();

    public ModuleTypeConversionPluginMetadataResolver() {
        this.conversionService.addConverter((Converter)new CustomMimeTypeConverter());
    }

    public ModuleOptionsMetadata resolve(ModuleDefinition moduleDefinition) {
        ArrayList<PojoModuleOptionsMetadata> moms = new ArrayList<PojoModuleOptionsMetadata>();
        ModuleType type = moduleDefinition.getType();
        if (type == ModuleType.source || type == ModuleType.processor) {
            moms.add(new PojoModuleOptionsMetadata(OutputOptionsMetadata.class, (ConversionService)this.conversionService));
        }
        if (type == ModuleType.sink || type == ModuleType.processor) {
            moms.add(new PojoModuleOptionsMetadata(InputOptionsMetadata.class, (ConversionService)this.conversionService));
        }
        switch (moms.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (ModuleOptionsMetadata)moms.iterator().next();
            }
        }
        return new FlattenedCompositeModuleOptionsMetadata(moms);
    }

    private static class OutputOptionsMetadata {
        private MimeType outputType;

        private OutputOptionsMetadata() {
        }

        public MimeType getOutputType() {
            return this.outputType;
        }

        @ModuleOption(value="how this module should emit messages it produces")
        public void setOutputType(MimeType outputType) {
            this.outputType = outputType;
        }
    }

    private static class InputOptionsMetadata {
        private MimeType inputType;

        private InputOptionsMetadata() {
        }

        public MimeType getInputType() {
            return this.inputType;
        }

        @ModuleOption(value="how this module should interpret messages it consumes")
        public void setInputType(MimeType inputType) {
            this.inputType = inputType;
        }
    }
}

