/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins.stream;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.xd.dirt.integration.bus.converter.AbstractFromMessageConverter;
import org.springframework.xd.dirt.integration.bus.converter.CompositeMessageConverterFactory;
import org.springframework.xd.dirt.plugins.AbstractPlugin;
import org.springframework.xd.dirt.plugins.stream.ModuleTypeConversionSupport;
import org.springframework.xd.module.ModuleType;
import org.springframework.xd.module.core.Module;

public class ModuleTypeConversionPlugin
extends AbstractPlugin {
    private static final Logger logger = LoggerFactory.getLogger(ModuleTypeConversionPlugin.class);
    private final CompositeMessageConverterFactory converterFactory;
    private final ModuleTypeConversionSupport moduleTypeConversionSupport;

    public ModuleTypeConversionPlugin(Collection<AbstractFromMessageConverter> converters, Collection<AbstractFromMessageConverter> customConverters) {
        if (!CollectionUtils.isEmpty(customConverters)) {
            converters.addAll(customConverters);
        }
        this.converterFactory = new CompositeMessageConverterFactory(converters);
        this.moduleTypeConversionSupport = new ModuleTypeConversionSupport(this.converterFactory);
    }

    public ModuleTypeConversionSupport getModuleTypeConversionSupport() {
        return this.moduleTypeConversionSupport;
    }

    @Override
    public void postProcessModule(Module module) {
        if (module.getType() == ModuleType.source || module.getType() == ModuleType.processor) {
            this.moduleTypeConversionSupport.configureModuleOutputChannelMessageConverters(module);
        }
        if (module.getType() == ModuleType.sink || module.getType() == ModuleType.processor) {
            this.moduleTypeConversionSupport.configureModuleInputChannelMessageConverters(module);
        }
    }

    @Override
    public boolean supports(Module module) {
        return module.shouldBind();
    }
}

