/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins.spark.streaming;

import java.util.Properties;
import org.springframework.boot.autoconfigure.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.redis.RedisAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.xd.dirt.server.MessageBusExtensionsConfiguration;

@Configuration
@Import(value={PropertyPlaceholderAutoConfiguration.class})
@ImportResource(value={"classpath*:META-INF/spring-xd/bus/${XD_TRANSPORT}-bus.xml"})
class MessageBusConfiguration {
    private static final String RABBIT_ACKMODE_PROPERTY = "xd.messagebus.rabbit.default.ackMode";
    private static final String KAFKA_AUTO_OFFSET_COMMIT_PROPERTY = "xd.messagebus.kafka.default.autoOffsetCommitEnabled";
    private static final String CODEC_KRYO_REFERENCES = "xd.codec.kryo.references";

    MessageBusConfiguration() {
    }

    static ConfigurableApplicationContext createApplicationContext(final Properties properties) {
        String transport = properties.getProperty("XD_TRANSPORT");
        properties.setProperty(RABBIT_ACKMODE_PROPERTY, "MANUAL");
        properties.setProperty(KAFKA_AUTO_OFFSET_COMMIT_PROPERTY, "false");
        properties.setProperty(CODEC_KRYO_REFERENCES, "true");
        SpringApplicationBuilder application = new SpringApplicationBuilder(new Object[0]).sources(new Class[]{MessageBusConfiguration.class}).listeners(new ApplicationListener[]{new ApplicationListener<ApplicationEnvironmentPreparedEvent>(){

            public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
                event.getEnvironment().getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("executorEnvironment", properties));
            }
        }}).web(false).showBanner(false);
        application.sources(new Class[]{MessageBusExtensionsConfiguration.class});
        if (transport.equals("rabbit")) {
            application.sources(new Class[]{RabbitAutoConfiguration.class});
        } else if (transport.equals("redis")) {
            application.sources(new Class[]{RedisAutoConfiguration.class});
        }
        application.run(new String[0]);
        return application.context();
    }
}

