/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins.job.support.listener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.SkipListener;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.xd.dirt.plugins.job.support.listener.BatchJobListener;

public class SimpleXdSkipListener
extends BatchJobListener<Object>
implements SkipListener<Object, Object> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleXdSkipListener.class);

    public SimpleXdSkipListener(SubscribableChannel skipEventsChannel, SubscribableChannel aggregatedEventsChannel) {
        super(skipEventsChannel, aggregatedEventsChannel);
    }

    public void onSkipInRead(Throwable t) {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing onSkipInRead: " + t.getMessage(), t);
        }
        Message message = MessageBuilder.withPayload((Object)"Skipped when reading.").setHeader("xd_batch_exception", (Object)t).build();
        this.publish(message);
    }

    public void onSkipInWrite(Object item, Throwable t) {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing onSkipInWrite: " + t.getMessage(), t);
        }
        this.publishWithThrowableHeader(item, t.getMessage());
    }

    public void onSkipInProcess(Object item, Throwable t) {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing onSkipInProcess: " + t.getMessage(), t);
        }
        this.publishWithThrowableHeader(item, t.getMessage());
    }
}

