/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins.job.support.listener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.xd.dirt.plugins.job.support.listener.BatchJobListener;

public class SimpleXdJobExecutionListener
extends BatchJobListener<JobExecution>
implements JobExecutionListener {
    private static final Logger logger = LoggerFactory.getLogger(SimpleXdJobExecutionListener.class);

    public SimpleXdJobExecutionListener(SubscribableChannel jobExecutionEventsChannel, SubscribableChannel aggregatedEventsChannel) {
        super(jobExecutionEventsChannel, aggregatedEventsChannel);
    }

    public void beforeJob(JobExecution jobExecution) {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing beforeJob: " + jobExecution);
        }
        this.publish(jobExecution);
    }

    public void afterJob(JobExecution jobExecution) {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing afterJob: " + jobExecution);
        }
        this.publish(jobExecution);
    }
}

