/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins.job.support.listener;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ItemProcessListener;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.xd.dirt.plugins.job.support.listener.BatchJobListener;

public final class SimpleXdItemListener<I, O>
extends BatchJobListener<Object>
implements ItemReadListener<I>,
ItemProcessListener<I, Object>,
ItemWriteListener<Object> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleXdItemListener.class);

    public SimpleXdItemListener(SubscribableChannel itemEventsChannel, SubscribableChannel aggregatedEventsChannel) {
        super(itemEventsChannel, aggregatedEventsChannel);
    }

    public void onReadError(Exception exception) {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing onReadError: " + exception.getMessage(), (Throwable)exception);
        }
        this.publish(exception.getMessage());
    }

    public void onProcessError(I item, Exception exception) {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing onProcessError: " + exception.getMessage(), (Throwable)exception);
        }
        this.publishWithThrowableHeader(item, exception.getMessage());
    }

    public void afterWrite(List<? extends Object> items) {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing afterWrite: " + items);
        }
        this.publish(items.size() + " items have been written.");
    }

    public void onWriteError(Exception exception, List<? extends Object> items) {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing onWriteError: " + exception.getMessage(), (Throwable)exception);
        }
        String payload = "Exception while " + items.size() + " items are attempted to be written.";
        this.publishWithThrowableHeader(payload, exception.getMessage());
    }

    public void beforeWrite(List<? extends Object> items) {
        this.publish(items.size() + " items to be written.");
    }

    public void beforeProcess(I item) {
    }

    public void afterProcess(I item, Object result) {
    }

    public void beforeRead() {
    }

    public void afterRead(I item) {
    }
}

