/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins.job.support.listener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.xd.dirt.plugins.job.support.listener.BatchJobListener;
import org.springframework.xd.dirt.plugins.job.support.listener.ChunkContextInfo;

public class SimpleXdChunkListener
extends BatchJobListener<ChunkContextInfo>
implements ChunkListener {
    private static final Logger logger = LoggerFactory.getLogger(SimpleXdChunkListener.class);

    public SimpleXdChunkListener(SubscribableChannel chunkEventsChannel, SubscribableChannel aggregatedEventsChannel) {
        super(chunkEventsChannel, aggregatedEventsChannel);
    }

    public void afterChunk(ChunkContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing afterChunk: " + context);
        }
        this.publish(this.convertChunkContext(context));
    }

    public void beforeChunk(ChunkContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing beforeChunk: " + context);
        }
        this.publish(this.convertChunkContext(context));
    }

    public void afterChunkError(ChunkContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing afterChunkError: " + context);
        }
        this.publish(this.convertChunkContext(context));
    }

    private ChunkContextInfo convertChunkContext(ChunkContext context) {
        String[] attributeNames;
        ChunkContextInfo chunkContextInfo = new ChunkContextInfo();
        chunkContextInfo.setComplete(context.isComplete());
        chunkContextInfo.setStepExecution(context.getStepContext().getStepExecution());
        for (String attributeName : attributeNames = context.attributeNames()) {
            Object attribute = context.getAttribute(attributeName);
            chunkContextInfo.getAttributes().put(attributeName, attribute);
        }
        return chunkContextInfo;
    }
}

