/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins.job.support.listener;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.core.io.Resource;

public class FileDeletionStepExecutionListener
implements StepExecutionListener {
    private boolean deleteFiles;
    private Resource[] resources;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void beforeStep(StepExecution stepExecution) {
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        if (!this.deleteFiles) {
            return stepExecution.getExitStatus();
        }
        if (stepExecution.getStatus().equals((Object)BatchStatus.STOPPED) || stepExecution.getStatus().isUnsuccessful()) {
            this.logger.warn("Job is stopped, or failed to complete successfully. File deletion will be skipped");
            return stepExecution.getExitStatus();
        }
        if (this.resources != null) {
            this.deleteResources();
        } else {
            this.deleteFilePath(stepExecution.getJobExecution().getJobParameters().getString("absoluteFilePath"));
        }
        return stepExecution.getExitStatus();
    }

    private void deleteResources() {
        for (Resource r : this.resources) {
            if (!r.exists()) continue;
            try {
                r.getFile().delete();
            }
            catch (IOException e) {
                this.logger.error("Failed to delete " + r, (Throwable)e);
            }
        }
    }

    private void deleteFilePath(String filePath) {
        if (filePath == null) {
            return;
        }
        File f = new File(filePath);
        if (f.exists()) {
            this.logger.info("Deleting file " + filePath);
            f.delete();
        } else {
            this.logger.warn("File '" + filePath + "' does not exist.");
        }
    }

    public void setDeleteFiles(boolean deleteFiles) {
        this.deleteFiles = deleteFiles;
    }

    public void setResources(Resource[] resources) {
        this.resources = Arrays.copyOf(resources, resources.length);
    }
}

