/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins.job.support.listener;

import org.springframework.messaging.Message;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.support.MessageBuilder;

public abstract class BatchJobListener<P> {
    private final SubscribableChannel listenerEventsChannel;
    private final SubscribableChannel aggregatedEventsChannel;

    public BatchJobListener(SubscribableChannel listenerEventsChannel, SubscribableChannel aggregatedEventsChannel) {
        this.listenerEventsChannel = listenerEventsChannel;
        this.aggregatedEventsChannel = aggregatedEventsChannel;
    }

    protected final void publish(P payload) {
        if (payload instanceof Message) {
            this.publishMessage((Message)payload);
            return;
        }
        Message message = MessageBuilder.withPayload(payload).build();
        this.listenerEventsChannel.send(message);
        this.aggregatedEventsChannel.send(message);
    }

    private final void publishMessage(Message<?> message) {
        this.listenerEventsChannel.send(message);
        this.aggregatedEventsChannel.send(message);
    }

    protected void publishWithThrowableHeader(P payload, String header) {
        Message message = MessageBuilder.withPayload(payload).setHeader("xd_batch_exception", (Object)header).build();
        this.publishMessage(message);
    }
}

