/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins.job.support;

import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.batch.core.repository.support.SimpleJobRepository;

public class JobLaunchingJobRepository
extends SimpleJobRepository {
    private JobInstanceDao jobInstanceDao;
    private JobExecutionDao jobExecutionDao;
    private StepExecutionDao stepExecutionDao;

    public JobLaunchingJobRepository(JobInstanceDao jobInstanceDao, JobExecutionDao jobExecutionDao, StepExecutionDao stepExecutionDao, ExecutionContextDao executionContextDao) {
        super(jobInstanceDao, jobExecutionDao, stepExecutionDao, executionContextDao);
        this.jobInstanceDao = jobInstanceDao;
        this.jobExecutionDao = jobExecutionDao;
        this.stepExecutionDao = stepExecutionDao;
    }

    public JobExecution getLastJobExecution(String jobName, JobParameters jobParameters) {
        JobInstance jobInstance = this.jobInstanceDao.getJobInstance(jobName, jobParameters);
        if (jobInstance == null) {
            return null;
        }
        JobExecution jobExecution = this.jobExecutionDao.getLastJobExecution(jobInstance);
        if (jobExecution != null) {
            this.stepExecutionDao.addStepExecutions(jobExecution);
        }
        return jobExecution;
    }

    public StepExecution getLastStepExecution(JobInstance jobInstance, String stepName) {
        List jobExecutions = this.jobExecutionDao.findJobExecutions(jobInstance);
        ArrayList<StepExecution> stepExecutions = new ArrayList<StepExecution>(jobExecutions.size());
        for (JobExecution jobExecution : jobExecutions) {
            this.stepExecutionDao.addStepExecutions(jobExecution);
            for (StepExecution stepExecution : jobExecution.getStepExecutions()) {
                if (!stepName.equals(stepExecution.getStepName())) continue;
                stepExecutions.add(stepExecution);
            }
        }
        StepExecution latest = null;
        for (StepExecution stepExecution : stepExecutions) {
            if (latest == null) {
                latest = stepExecution;
            }
            if (latest.getStartTime().getTime() >= stepExecution.getStartTime().getTime()) continue;
            latest = stepExecution;
        }
        return latest;
    }
}

